﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_SND_EXTERNAL_SOUND_PLAYER_H_
#define NW_SND_EXTERNAL_SOUND_PLAYER_H_

#include <nw/ut/ut_LinkList.h>
#include <nw/snd/snd_BasicSound.h>

namespace nw {
namespace snd {

class SoundActor;

namespace internal {

/* ========================================================================
        class difinition
   ======================================================================== */

class ExternalSoundPlayer
{
    /* ------------------------------------------------------------------------
            typename definition
       ------------------------------------------------------------------------ */
public:
    typedef ut::LinkList< BasicSound, offsetof(BasicSound,m_ExtSoundPlayerPlayLink)> SoundList;

    /* ------------------------------------------------------------------------
            class member
       ------------------------------------------------------------------------ */
public:
    ExternalSoundPlayer();
    ~ExternalSoundPlayer();

    void StopAllSound( int fadeFrames );
    void PauseAllSound( bool flag, int fadeFrames );

    // 同時再生数
    int GetPlayingSoundCount() const { return static_cast<int>( m_SoundList.GetSize()); }
    void SetPlayableSoundCount( int count );
    int GetPlayableSoundCount() const { return m_PlayableCount; }

    // プレイヤーでサウンドを再生可能かどうかを調べる
    bool detail_CanPlaySound( int startPriority );

    // サウンド登録
    bool AppendSound( internal::BasicSound* sound );
    void RemoveSound( internal::BasicSound* sound );

    // 全てのサウンドに対する処理
    template< class Function >
    void ForEachSoundRef( Function& function, bool reverse = false );

    template< class Function >
    Function ForEachSound( Function function, bool reverse = false );

    void Finalize( SoundActor* actor );

private:
    internal::BasicSound* GetLowestPrioritySound();

    SoundList m_SoundList;
    int m_PlayableCount;
};

template< class Function >
inline void ExternalSoundPlayer::ForEachSoundRef( Function& function, bool reverse )
{
    if ( reverse )
    {
        // 再生の新しい順
        for ( SoundList::ReverseIterator itr = m_SoundList.GetBeginReverseIter();
              itr != m_SoundList.GetEndReverseIter();
            )
        {
            SoundList::ReverseIterator curItr = itr;
            SoundHandle handle;
            handle.detail_AttachSoundAsTempHandle( &( *curItr ) );
            function( handle );
            if ( handle.IsAttachedSound() ) itr++;
        }
    }
    else
    {
        // 再生の古い順
        for ( SoundList::Iterator itr = m_SoundList.GetBeginIter();
              itr != m_SoundList.GetEndIter();
            )
        {
            SoundList::Iterator curItr = itr++;
            SoundHandle handle;
            handle.detail_AttachSoundAsTempHandle( &( *curItr ) );
            function( handle );
        }
    }
}

template< class Function >
inline Function ExternalSoundPlayer::ForEachSound( Function function, bool reverse )
{
    if ( reverse )
    {
        // 再生の新しい順
        for ( SoundList::ReverseIterator itr = m_SoundList.GetBeginReverseIter();
              itr != m_SoundList.GetEndReverseIter();
            )
        {
            SoundList::ReverseIterator curItr = itr;
            SoundHandle handle;
            handle.detail_AttachSoundAsTempHandle( &( *curItr ) );
            function( handle );
            if ( handle.IsAttachedSound() ) itr++;
        }
    }
    else
    {
        // 再生の古い順
        for ( SoundList::Iterator itr = m_SoundList.GetBeginIter();
              itr != m_SoundList.GetEndIter();
            )
        {
            SoundList::Iterator curItr = itr++;
            SoundHandle handle;
            handle.detail_AttachSoundAsTempHandle( &( *curItr ) );
            function( handle );
        }
    }
    return function;
}

} // namespace nw::snd::internal
} // namespace nw::snd
} // namespace nw


#endif /* NW_SND_EXTERNAL_SOUND_PLAYER_H_ */

