﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_SND_DRIVER_COMMAND_H_
#define NW_SND_DRIVER_COMMAND_H_

#include <nw/snd/snd_StreamSoundPlayer.h>
#include <nw/snd/snd_StreamSoundFile.h>
#include <nw/snd/snd_StreamSoundFileReader.h>
#include <nw/snd/snd_SoundArchive.h>
#include <nw/snd/snd_Global.h>
#include <nw/snd/snd_SequenceSound.h>
#include <nw/snd/snd_WaveSound.h>
#include <nw/snd/snd_StreamSound.h>
#include <nw/snd/snd_Command.h>
#include <nw/snd/snd_CommandManager.h>

namespace nw {
namespace snd {

class FxBase;
struct AdpcmParam;
struct WaveBuffer;

namespace internal {

namespace driver {
class BasicSoundPlayer;
class SequenceSoundPlayer;
class SequenceTrackAllocator;
class NoteOnCallback;
class WaveSoundPlayer;
class StreamSoundPlayer;
class StreamBufferPool;
class DisposeCallback;
class MultiVoice;
}

enum DriverCommandId
{
    DRIVER_COMMAND_DUMMY,
    DRIVER_COMMAND_DEBUG,
    DRIVER_COMMAND_REPLY,
    DRIVER_COMMAND_PLAYER_INIT,
    DRIVER_COMMAND_PLAYER_RENDERER_TYPE,
    DRIVER_COMMAND_PLAYER_PANMODE,
    DRIVER_COMMAND_PLAYER_PANCURVE,
    DRIVER_COMMAND_PLAYER_REMOTE_FILTER,
    DRIVER_COMMAND_PLAYER_FRONT_BYPASS,
    DRIVER_COMMAND_PLAYER_FINALIZE,
    DRIVER_COMMAND_PLAYER_START,
    DRIVER_COMMAND_PLAYER_STOP,
    DRIVER_COMMAND_PLAYER_PAUSE,
    DRIVER_COMMAND_PLAYER_PARAM,
    DRIVER_COMMAND_PLAYER_CLEAR_RESOURCEFLAG,
    DRIVER_COMMAND_SEQ_SETUP,
    DRIVER_COMMAND_SEQ_LOAD,
    DRIVER_COMMAND_SEQ_PREPARE,
    DRIVER_COMMAND_SEQ_SKIP,
    DRIVER_COMMAND_SEQ_TEMPORATIO,
    DRIVER_COMMAND_SEQ_CHANNELPRIO,
    DRIVER_COMMAND_SEQ_SETVAR,
    DRIVER_COMMAND_SEQ_SETGVAR,
    DRIVER_COMMAND_SEQ_SETTVAR,
    DRIVER_COMMAND_SEQTRACK_MUTE,
    DRIVER_COMMAND_SEQTRACK_SILENCE,
    DRIVER_COMMAND_SEQTRACK_VOLUME,
    DRIVER_COMMAND_SEQTRACK_PITCH,
    DRIVER_COMMAND_SEQTRACK_LPF,
    DRIVER_COMMAND_SEQTRACK_BIQUAD,
    DRIVER_COMMAND_SEQTRACK_BANKINDEX,
    DRIVER_COMMAND_SEQTRACK_TRANSPOSE,
    DRIVER_COMMAND_SEQTRACK_VELOCITYRANGE,
    DRIVER_COMMAND_SEQTRACK_OUTPUTLINE,
    DRIVER_COMMAND_SEQTRACK_OUTPUTLINE_RESET,
    DRIVER_COMMAND_SEQTRACK_TV_VOLUME,
    DRIVER_COMMAND_SEQTRACK_TV_MIXPARAMETER,
    DRIVER_COMMAND_SEQTRACK_TV_PAN,
    DRIVER_COMMAND_SEQTRACK_TV_SPAN,
    DRIVER_COMMAND_SEQTRACK_TV_MAINSEND,
    DRIVER_COMMAND_SEQTRACK_TV_FXSEND,
    DRIVER_COMMAND_SEQTRACK_DRC_VOLUME,
    DRIVER_COMMAND_SEQTRACK_DRC_MIXPARAMETER,
    DRIVER_COMMAND_SEQTRACK_DRC_PAN,
    DRIVER_COMMAND_SEQTRACK_DRC_SPAN,
    DRIVER_COMMAND_SEQTRACK_DRC_MAINSEND,
    DRIVER_COMMAND_SEQTRACK_DRC_FXSEND,
    DRIVER_COMMAND_WSD_PREPARE,
    DRIVER_COMMAND_WSD_LOAD,
    DRIVER_COMMAND_WSD_CHANNEL_PRIO,
    DRIVER_COMMAND_WSD_CHANNEL_PARAM,
    DRIVER_COMMAND_STRM_SETUP,
    DRIVER_COMMAND_STRM_PREPARE,
    DRIVER_COMMAND_STRM_PREPARE_PREFETCH,
    DRIVER_COMMAND_STRM_LOADHEADER,
    DRIVER_COMMAND_STRM_LOADDATA,
    DRIVER_COMMAND_STRM_FORCE_FINISH,
    DRIVER_COMMAND_STRM_TRACK_VOLUME,
    DRIVER_COMMAND_STRM_TRACK_INITIAL_VOLUME,
    DRIVER_COMMAND_STRM_TRACK_OUTPUTLINE,
    DRIVER_COMMAND_STRM_TRACK_OUTPUTLINE_RESET,
    DRIVER_COMMAND_STRM_TRACK_TV_VOLUME,
    DRIVER_COMMAND_STRM_TRACK_TV_MIXPARAMETER,
    DRIVER_COMMAND_STRM_TRACK_TV_PAN,
    DRIVER_COMMAND_STRM_TRACK_TV_SPAN,
    DRIVER_COMMAND_STRM_TRACK_TV_MAINSEND,
    DRIVER_COMMAND_STRM_TRACK_TV_FXSEND,
    DRIVER_COMMAND_STRM_TRACK_DRC_VOLUME,
    DRIVER_COMMAND_STRM_TRACK_DRC_MIXPARAMETER,
    DRIVER_COMMAND_STRM_TRACK_DRC_PAN,
    DRIVER_COMMAND_STRM_TRACK_DRC_SPAN,
    DRIVER_COMMAND_STRM_TRACK_DRC_MAINSEND,
    DRIVER_COMMAND_STRM_TRACK_DRC_FXSEND,
    DRIVER_COMMAND_INVALIDATE_DATA,
    DRIVER_COMMAND_REGIST_DISPOSE_CALLBACK,
    DRIVER_COMMAND_UNREGIST_DISPOSE_CALLBACK,
    DRIVER_COMMAND_APPEND_EFFECT,
    DRIVER_COMMAND_CLEAR_EFFECT,
    DRIVER_COMMAND_ALLVOICES_SYNC,
    DRIVER_COMMAND_VOICE_PLAY,
    DRIVER_COMMAND_VOICE_WAVEINFO,
    DRIVER_COMMAND_VOICE_ADPCM_PARAM,
    DRIVER_COMMAND_VOICE_APPEND_WAVEBUFFER,
    DRIVER_COMMAND_VOICE_PRIORITY,
    DRIVER_COMMAND_VOICE_VOLUME,
    DRIVER_COMMAND_VOICE_PITCH,
    DRIVER_COMMAND_VOICE_PAN_MODE,
    DRIVER_COMMAND_VOICE_PAN_CURVE,
    DRIVER_COMMAND_VOICE_PAN,
    DRIVER_COMMAND_VOICE_SPAN,
    DRIVER_COMMAND_VOICE_LPF,
    DRIVER_COMMAND_VOICE_BIQUAD,
    DRIVER_COMMAND_VOICE_OUTPUT_LINE,
    DRIVER_COMMAND_VOICE_MAIN_OUT_VOLUME,
    DRIVER_COMMAND_VOICE_REMOTE_OUT_VOLUME,
    DRIVER_COMMAND_VOICE_DRC_OUT_VOLUME,
    DRIVER_COMMAND_VOICE_MAIN_SEND,
    DRIVER_COMMAND_VOICE_FX_SEND
};

struct DriverCommandDebug : public Command
{
    char str[256];
};

struct DriverCommandReply : public Command
{
    bool* ptr;
};

struct DriverCommandPlayer : public Command
{
    driver::BasicSoundPlayer* player;
    bool flag;
    u8 padding[3];
};

struct DriverCommandPlayerInit : public Command
{
    driver::BasicSoundPlayer* player;
    bool* availableFlagPtr;
};

struct DriverCommandPlayerRendererType : public Command
{
    driver::BasicSoundPlayer* player;
    u8 rendererType;    // VoiceRendererType
    u8 padding[3];
};

struct DriverCommandPlayerPanParam : public Command
{
    driver::BasicSoundPlayer* player;
    u8 panMode;         // PanMode
    u8 panCurve;        // PanCurve
    u8 padding[2];
};

struct DriverCommandPlayerRemoteFilter : public Command
{
    driver::BasicSoundPlayer* player;
    u8 remoteFilter;
    u8 padding[3];
};

struct DriverCommandPlayerFrontBypass : public Command
{
    driver::BasicSoundPlayer* player;
    bool isFrontBypass;
    u8 padding[3];
};

struct DriverCommandPlayerParam : public Command
{
    driver::BasicSoundPlayer* player;
    f32 volume;
    f32 pitch;
    f32 lpfFreq;
    int biquadFilterType;
    f32 biquadFilterValue;
    u32 outputLineFlag;

    OutputParam tvParam;
    OutputParam drcParam[DRC_OUT_COUNT];
    RemoteOutputParam remoteParam[REMOTE_OUT_COUNT];
};

struct DriverCommandPlayerClearResourceFlag : public Command
{
    driver::BasicSoundPlayer* player;
};

struct DriverCommandSequenceSoundSetup : public Command
{
    driver::SequenceSoundPlayer* player;
    driver::SequenceSoundPlayer::SetupArg arg;
    u8 channelPriority;
    bool isReleasePriorityFix;
    uptr userproc;
    void* userprocArg;
};

struct DriverCommandSequenceSoundLoad : public Command
{
    driver::SequenceSoundPlayer* player;
    driver::SequenceSoundPlayer::StartInfo startInfo;
    driver::SequenceSoundLoader::Arg arg;
};

struct DriverCommandSequenceSoundPrepare : public Command
{
    driver::SequenceSoundPlayer* player;
    driver::SequenceSoundPlayer::PrepareArg arg;
};

struct DriverCommandSequenceSoundSkip : public Command
{
    driver::SequenceSoundPlayer* player;
    int offsetType;
    int offset;
};

struct DriverCommandSequenceSoundTempoRatio : public Command
{
    driver::SequenceSoundPlayer* player;
    f32 tempoRatio;
};

struct DriverCommandSequenceSoundChannelPrio : public Command
{
    driver::SequenceSoundPlayer* player;
    u8 priority;
    u8 padding[3];
};

struct DriverCommandSequenceSoundSetVar : public Command
{
    driver::SequenceSoundPlayer* player;
    int trackNo;
    int varNo;
    s32 var;
};

struct DriverCommandSequenceSoundTrack : public Command
{
    driver::SequenceSoundPlayer* player;
    u32 trackBitFlag;
};

struct DriverCommandSequenceSoundTrackMute : public DriverCommandSequenceSoundTrack
{
    int mute;
};

struct DriverCommandSequenceSoundTrackSilence : public DriverCommandSequenceSoundTrack
{
    bool silenceFlag;
    int fadeFrames;
};

struct DriverCommandSequenceSoundTrackParam : public DriverCommandSequenceSoundTrack
{
    f32 value;
    u32 u32Value;
};

struct DriverCommandSequenceSoundTrackDrcParam : public DriverCommandSequenceSoundTrackParam
{
    u32 drcIndex;
};

struct DriverCommandSequenceSoundTrackBiquad : public DriverCommandSequenceSoundTrack
{
    int type;
    f32 value;
};

struct DriverCommandSequenceSoundTrackBankIndex : public DriverCommandSequenceSoundTrack
{
    int bankIndex;
};

struct DriverCommandSequenceSoundTrackTranspose : public DriverCommandSequenceSoundTrack
{
    s8 transpose;
};

struct DriverCommandSequenceSoundTrackVelocityRange : public DriverCommandSequenceSoundTrack
{
    u8 range;
};

struct DriverCommandSequenceSoundTrackOutputLine : public DriverCommandSequenceSoundTrack
{
    u32 outputLine;
};

struct DriverCommandSequenceSoundTrackMixParameter : public DriverCommandSequenceSoundTrack
{
    u32 trackBitFlag;
    u32 srcChNo;
    MixParameter param;
    u32 drcIndex;
};

struct DriverCommandWaveSoundPrepare : public Command
{
    driver::WaveSoundPlayer* player;
    driver::WaveSoundPlayer::StartInfo startInfo;
    driver::WaveSoundPlayer::PrepareArg arg;
};

struct DriverCommandWaveSoundLoad : public Command
{
    driver::WaveSoundPlayer* player;
    driver::WaveSoundPlayer::StartInfo startInfo;
    driver::WaveSoundLoader::Arg arg;
};

struct DriverCommandWaveSoundChannelPrio : public Command
{
    driver::WaveSoundPlayer* player;
    u8 priority;
    u8 padding[3];
};

struct DriverCommandWaveSoundChannelParam : public Command
{
    driver::WaveSoundPlayer* player;
    u8 priority;
    bool isReleasePriorityFix;
    u8 padding[2];
};

struct DriverCommandStreamSoundSetup : public Command
{
    driver::StreamSoundPlayer* player;
    driver::StreamSoundPlayer::SetupArg arg;
};

struct DriverCommandStreamSoundPrepare : public Command
{
    driver::StreamSoundPlayer* player;
    driver::StreamSoundPlayer::PrepareArg arg;
};

struct DriverCommandStreamSoundPreparePrefetch : public Command
{
    driver::StreamSoundPlayer* player;
    driver::StreamSoundPlayer::PreparePrefetchArg arg;
};

struct DriverCommandStreamSoundLoadHeader : public Command
{
    driver::StreamSoundPlayer* player;
    bool result;
    AdpcmParam* adpcmParam[STRM_CHANNEL_NUM];
    u16 requestIndex;
};

struct DriverCommandStreamSoundLoadData : public Command
{
    driver::StreamSoundPlayer* player;
    bool result;
    LoadDataParam loadDataParam;
};

struct DriverCommandStreamSoundForceFinish : public Command
{
    driver::StreamSoundPlayer* player;
};

struct DriverCommandStreamSoundTrackParam : public Command
{
    driver::StreamSoundPlayer* player;
    u32 trackBitFlag;
    f32 value;
    u32 u32Value;
    u32 drcIndex;
};

struct DriverCommandStreamSoundTrackInitialVolume : public Command
{
    driver::StreamSoundPlayer* player;
    u32 trackBitFlag;
    u32 value;
};

struct DriverCommandStreamSoundTrackMixParameter : public Command
{
    driver::StreamSoundPlayer* player;
    u32 trackBitFlag;
    u32 srcChNo;
    MixParameter param;
    u32 drcIndex;
};

struct DriverCommandInvalidateData : public Command
{
    const void* mem;
    unsigned long size;
};

struct DriverCommandDisposeCallback : public Command
{
    driver::DisposeCallback* callback;
};

struct DriverCommandEffect : public Command
{
    AuxBus bus;
    FxBase* effect;
    OutputDevice device;
    int fadeTimes;
};

struct DriverCommandAllVoicesSync : public Command
{
    u32 syncFlag;
};


//
// Voice → MultiVoice の操作
//
struct DriverCommandVoice : public Command
{
    driver::MultiVoice* voice;
};

struct DriverCommandVoicePlay : public DriverCommandVoice
{
    enum State
    {
        STATE_START,
        STATE_STOP,
        STATE_PAUSE_ON,
        STATE_PAUSE_OFF
    };
    State state;
};

struct DriverCommandVoiceWaveInfo : public DriverCommandVoice
{
    SampleFormat format;
    int sampleRate;
    int interpolationType;
};

struct DriverCommandVoiceAdpcmParam : public DriverCommandVoice
{
    int channel;
    int voiceOut;
    const AdpcmParam* param;
};

struct DriverCommandVoiceAppendWaveBuffer : public DriverCommandVoice
{
    int channel;
    int voiceOut;
    WaveBuffer* buffer;
    bool lastFlag;
};

struct DriverCommandVoicePriority : public DriverCommandVoice
{
    int priority;
};

struct DriverCommandVoiceVolume : public DriverCommandVoice
{
    f32 volume;
};

struct DriverCommandVoicePitch : public DriverCommandVoice
{
    f32 pitch;
};

struct DriverCommandVoicePanMode : public DriverCommandVoice
{
    PanMode mode;
};

struct DriverCommandVoicePanCurve : public DriverCommandVoice
{
    PanCurve curve;
};

struct DriverCommandVoicePan : public DriverCommandVoice
{
    f32 pan;
};

struct DriverCommandVoiceSurroundPan: public DriverCommandVoice
{
    f32 span;
};

struct DriverCommandVoiceLpfFreq : public DriverCommandVoice
{
    f32 lpfFreq;
};

struct DriverCommandVoiceBiquadFilter : public DriverCommandVoice
{
    int type;
    f32 value;
};

struct DriverCommandVoiceOutputLine : public DriverCommandVoice
{
    u32 lineFlag;
};

struct DriverCommandVoiceMainOutVolume : public DriverCommandVoice
{
    f32 volume;
};

struct DriverCommandVoiceRemoteOutVolume : public DriverCommandVoice
{
    int remoteIndex;
    f32 volume;
};

struct DriverCommandVoiceDrcOutVolume : public DriverCommandVoice
{
    int drcIndex;
    f32 volume;
};

struct DriverCommandVoiceMainSend : public DriverCommandVoice
{
    f32 send;
};

struct DriverCommandVoiceFxSend : public DriverCommandVoice
{
    AuxBus bus;
    f32 send;
};

class DriverCommand : public CommandManager
{
public:
    static DriverCommand& GetInstance();
    static DriverCommand& GetInstanceForTaskThread();

    void Initialize( void* commandBuffer, u32 commandBufferSize );

private:
    DriverCommand();

    static void ProcessCommandList( Command* commandList );
    static void RequestProcessCommand();
};

} // namespace nw::snd::internal
} // namespace nw::snd
} // namespace nw


#endif /* NW_SND_DRIVER_COMMAND_H_ */

