﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_SNDFND_STRING_H_
#define NW_SNDFND_STRING_H_

#include <nw/types.h>

namespace nw {
namespace snd {
namespace internal {
namespace fnd {

//---------------------------------------------------------------------------
//! @brief    文字列を操作、管理します。
//!
//! @details  HACK : このクラスは実装途中です。
//!                  必要になった機能だけを随時実装していきます。
//---------------------------------------------------------------------------
class String
{
public:
    static const s32 INDEX_NOT_FOUND = -1;


private:
    // 現状はインスタンス生成できる意味がないので禁止します。
    String() { }

public:
    //! 文字列をコピーします。
    //! @param[in] dest コピー先です。
    //! @param[in] destLength コピー先に格納可能な文字数です。
    //! @param[in] source コピー元です。
    //! @param[in] sourceLength コピーする文字列長です。
    static void Copy(char* dest, u32 destLength, const char* source, u32 sourceLength);

    //! 文字列をコピーし、必要なら終端文字を設定します。
    //! @param[in] dest コピー先です。
    //! @param[in] destLength コピー先に格納可能な文字数です。
    //! @param[in] source コピー元です。
    //! @param[in] sourceLength コピーする文字列長です。
    static void SafeCopy(char* dest, u32 destLength, const char* source, u32 sourceLength);

#if !defined( NW_PLATFORM_CTR )
    //! 指定した文字を文字列の先頭から検索します。
    //! @param[in] source 検索対象の文字列です。
    //! @param[in] targetChar 検索する文字です。
    //! @param[in] maxLength 検索を行う最大文字数です。
    //! @return 最初に見つかったインデックスを返します。見つからないときには INDEX_NOT_FOUND を返します。
    static s32 IndexOf(const char* source, char targetChar, u32 maxLength);

    //! 指定した文字を文字列の末尾から検索します。
    //! @param[in] source 検索対象の文字列です。
    //! @param[in] targetChar 検索する文字です。
    //! @param[in] maxLength 検索を行う最大文字数です。
    //! @return 最後に見つかったインデックスを返します。見つからないときには INDEX_NOT_FOUND を返します。
    static s32 LastIndexOf(const char* source, char targetChar, u32 maxLength);
#endif
};

} // namespace nw::snd::internal::fnd
} // namespace nw::snd::internal
} // namespace nw::snd
} // namespace nw

#endif // NW_SNDFND_STRING_H_

