﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_SNDFND_FIXED_STRING_H_
#define NW_SNDFND_FIXED_STRING_H_

#include <string.h>
#include <nw/types.h>

namespace nw {
namespace snd {
namespace internal {
namespace fnd {

//---------------------------------------------------------------------------
//! @brief    固定長文字列を操作、管理します。
//!
//! @details  HACK : このクラスは実装途中です。
//!                  必要になった機能を随時実装していきます。
//---------------------------------------------------------------------------
class FixedString
{
public:
    /* ctor */ FixedString();
    /* ctor */ FixedString(char* buffer, u32 bufferLength);

public:
    //! @brief  文字列バッファをアタッチします。
    //! @param[in] buffer 文字列バッファです。
    //! @param[in] bufferLength 文字列バッファの長さです。
    void Attach(char* buffer, u32 bufferLength);

    //! @brief  文字列バッファをデタッチします。
    void Detach();

    //! @brief  アタッチの有無を調べます。
    //! @return 文字列バッファがアタッチされていれば true を返します。
    bool IsAttached() const { return m_Buffer != NULL; }

    //! @brief  文字列バッファの長さを取得します。
    //! @return 文字列バッファの長さを返します。
    u32 GetBufferLength() const { return m_BufferLength; }

    //! @brief  文字列の長さを取得します。
    //! @return 文字列の長さを返します。
    u32 GetLength() const { return m_Buffer == NULL ? 0 : ::strlen(m_Buffer); }

    //! @brief  文字列ポインタを取得します。
    //! @return 文字列ポインタを返します。
    char* GetValue() { return m_Buffer; }

    //! @brief  文字列ポインタを取得します。
    //! @return 文字列ポインタを返します。
    const char* GetValue() const { return m_Buffer; }

    //! @brief  指定文字列を設定（コピー）して終端文字を付加します。
    //! @param[in] value 文字列です。
    //! @param[in] length コピーする文字列長です。
    //! @param[in] index コピー先のインデックスです。
    void CopyFrom(const char* value, u32 length, u32 index = 0);

    //! @brief  指定文字列を設定（コピー）します。
    //! @param[in] value 文字列
    //! @param[in] length コピーする文字列長
    //! @param[in] index コピー先のインデックス
    void CopyPartFrom(const char* value, u32 length, u32 index = 0);

    //! @brief  インデクサです。
    //! @param[in] index インデックスです。
    //! @return 文字への参照を返します。
    char& operator[](u32 index)
    {
        NW_ASSERTMSG(index < m_BufferLength, "invalid index.\n");
        return m_Buffer[index];
    }

private:
    char* m_Buffer;         //!< 文字列バッファです。
    u32   m_BufferLength;   //!< バッファの長さです。
};

} // namespace nw::snd::internal::fnd
} // namespace nw::snd::internal
} // namespace nw::snd
} // namespace nw

#endif // NW_SNDFND_FIXED_STRING_H_

