﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_SND_FND_WAVE_FORMAT_H_
#define NW_SND_FND_WAVE_FORMAT_H_

namespace nw {
namespace snd {
namespace internal {
namespace fnd {

//---------------------------------------------------------------------------
//! @brief  波形フォーマット情報を格納します。
//---------------------------------------------------------------------------
struct WaveFormat
{
    WaveFormat() :
        channels(0),
        bitsPerSample(0),
        padding(0),
        samplesPerSec(0)
    { }

    //---------------------------------------------------------------------------

    u8 channels;
    u8 bitsPerSample;
    u16 padding;
    u32 samplesPerSec;
};

} // namespace nw::snd::internal::fnd
} // namespace nw::snd::internal
} // namespace nw::snd
} // namespace nw

#endif // NW_SND_FND_WAVE_FORMAT_H_
