﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_SND_FND_AIFF_STREAM_H_
#define NW_SND_FND_AIFF_STREAM_H_

#include <nw/ut/ut_Inlines.h>
#include <nw/snd/fnd/basis/sndfnd_Result.h>
#include <nw/snd/fnd/io/sndfnd_Stream.h>
#include <nw/snd/fnd/io/sndfnd_WaveformStream.h>
#include <nw/snd/fnd/model/sndfnd_WaveFormat.h>

namespace nw {
namespace snd {
namespace internal {
namespace fnd {

//---------------------------------------------------------------------------
//! @brief  AIFF バイナリストリームを入力します。
//---------------------------------------------------------------------------
class AiffStreamReader : public WaveformStreamReader
{
    NW_DISALLOW_COPY_AND_ASSIGN(AiffStreamReader);

public: // コンストラクタ
    AiffStreamReader();
    explicit AiffStreamReader(Stream* stream);
    virtual ~AiffStreamReader() { }

public: // メソッド
    FndResult Open(Stream* stream);
    virtual void Close();

    virtual bool IsOpened() const
    {
        return m_Stream != NULL && m_Stream->IsOpened();
    }

    virtual bool IsHeaderRead() const
    {
        return m_DataOffset > 0 && m_DataSize > 0;
    }

    virtual FndResult ReadHeader();
    virtual u32 ReadFrames(void* buffer, u32 frames, FndResult* result = NULL);

    virtual const WaveFormat& GetWaveFormat() const { return m_WaveFormat; }
    virtual u8 GetBlockAlignment() const { return m_BlockAlignment; }
    virtual u32 GetDataSize() const { return m_DataSize; }

private:
    FndResult ReadFormChunk();

    bool ReadImpl(void* pBuffer, u32 size);

private: // メンバ変数
    Stream* m_Stream;

    WaveFormat m_WaveFormat;
    u8         m_BlockAlignment;
    u8         m_Padding1;
    u16        m_Padding2;
    u32        m_DataOffset;
    u32        m_DataSize;
    u32        m_CurrentDataPosition;
};

} // namespace nw::snd::internal::fnd
} // namespace nw::snd::internal
} // namespace nw::snd
} // namespace nw

#endif // NW_SND_FND_AIFF_STREAM_H_
