﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_SND_FND_WAV_BINARY_H_
#define NW_SND_FND_WAV_BINARY_H_

#include <nw/snd/fnd/binary/sndfnd_PrimitiveTypes.h>
#include <nw/snd/fnd/binary/sndfnd_Binary.h>
#include <nw/snd/fnd/binary/sndfnd_IffBinary.h>

namespace nw {
namespace snd {
namespace internal {
namespace fnd {

#pragma pack(push, 1)

//---------------------------------------------------------------------------
//! @brief  RIFF チャンク
//---------------------------------------------------------------------------
struct RiffChunk
{
    static const u32 ValidID = NW_SND_BINARY_MAKE_SIGNATURE('R', 'I', 'F', 'F');

    RiffChunk() :
        header(ValidID),
        formatType(0)
    { }

    bool IsValid()
    {
        return header.id == ValidID;
    }

    ChunkHeader header;
    u32 formatType;
};

//---------------------------------------------------------------------------
//! @brief  fmt チャンク
//---------------------------------------------------------------------------
struct FmtChunk
{
    static const u32 ValidID = NW_SND_BINARY_MAKE_SIGNATURE('f', 'm', 't', ' ');
    static const u16 FORMAT_PCM = 1;

    FmtChunk() :
        header(ValidID, GetValidBodySize()),
        formatTag(0),
        channels(0),
        samplesPerSec(0),
        avgBytesPerSec(0),
        blockAlign(0),
        bitsPerSample(0)
    { }

    static u32 GetValidBodySize()
    {
        return sizeof(FmtChunk) - sizeof(ChunkHeader);
    }

    bool IsValid()
    {
        return header.id == ValidID;
    }

    ChunkHeader header;
    PcBinU16 formatTag;
    PcBinU16 channels;
    PcBinU32 samplesPerSec;
    PcBinU32 avgBytesPerSec;
    PcBinU16 blockAlign;
    PcBinU16 bitsPerSample;
};

//---------------------------------------------------------------------------
//! @brief  data チャンク
//---------------------------------------------------------------------------
struct DataChunk
{
    static const u32 ValidID = NW_SND_BINARY_MAKE_SIGNATURE('d', 'a', 't', 'a');

    DataChunk() : header(ValidID) { }

    bool IsValid()
    {
        return header.id == ValidID;
    }

    ChunkHeader header;
};

//---------------------------------------------------------------------------
//! @brief  WAV バイナリヘッダ
//---------------------------------------------------------------------------
struct WaveBinaryHeader
{
    WaveBinaryHeader()
    {
        riffChunk.formatType = NW_SND_BINARY_MAKE_SIGNATURE('W', 'A', 'V', 'E');
    }

    RiffChunk riffChunk;
    FmtChunk fmtChunk;
    DataChunk dataChunk;
};

#pragma pack(pop)

} // namespace nw::snd::internal::fnd
} // namespace nw::snd::internal
} // namespace nw::snd
} // namespace nw

#endif // NW_SND_FND_WAV_BINARY_H_
