﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_SND_EDIT_HIO_STREAM_H_
#define NW_SND_EDIT_HIO_STREAM_H_

#include <nw/snd/snd_Config.h>
#ifdef NW_SND_CONFIG_ENABLE_DEV

#if !defined(NW_PLATFORM_CTR)
//#define NW_SND_EDIT_USE_MCS
#endif

#if defined(NW_SND_EDIT_USE_MCS)
#include <nw/mcs/mcs_McsIoStream.h>
#else
#include <nw/snd/fnd/io/sndfnd_HioStream.h>
#endif

#if defined(NW_PLATFORM_CTR)
#if NN_CURRENT_VERSION_NUMBER >= NN_VERSION_NUMBER(4,0,0,0)
#pragma diag_suppress 1301 // padding inserted in struct.
#pragma diag_suppress 2530 // padding added to end of struct.
#endif
#endif

namespace nw {
namespace snd {
namespace edit {
namespace internal {

//---------------------------------------------------------------------------
//! @brief    HIOで使用するストリームクラスです。
//---------------------------------------------------------------------------
class HioStream
{
public:
#if defined(NW_SND_EDIT_USE_MCS)
    typedef u16 ChannelType;
#else
    typedef nw::snd::internal::fnd::HioStream::ChannelType ChannelType;
#endif

public:
    /* ctor */ HioStream();
    /* dtor */ virtual ~HioStream() { }

public:
#if !defined(NW_SND_EDIT_USE_MCS)
    //! @brief ストリームの初期化を行います。
    //! @param workBuffer TBD
    //! @param workBufferLength TBD
    void Initialize(void* workBuffer, u32 workBufferLength);

    //! @brief ストリームの破棄を行います。
    void Finalize();
#endif

    //! @brief ストリームをオープンします。
    //! @param channel TBD
    //! @param buffer TBD
    //! @param length TBD
    //! @return TBD
    bool Open(ChannelType channel, void* buffer, u32 length);

    //! @brief ストリームをクローズします。
    void Close();

    //! @brief ストリームがオープンされているかどうかを取得します。
    //! @return TBD
    bool IsAvailable() const;

    //! @brief ストリームから読み込み可能なサイズを取得します。
    //! @return TBD
    u32 GetReadableBytes();

    //! @brief 同期リードします。
    //! @param buffer TBD
    //! @param length TBD
    //! @return TBD
    s32 Read(void* buffer, u32 length);

    //! @brief データをスキップします。
    //! @param length TBD
    //! @return TBD
    s32 Skip(u32 length);

    //! @brief 同期ライトします。
    //! @param buffer TBD
    //! @param length TBD
    //! @return TBD
    s32 Write(const void* buffer, u32 length);

    //! @brief  ポーリングします。
    //! @return TBD
    bool Polling();

private:
#if defined(NW_SND_EDIT_USE_MCS)
    mcs::McsIoStream m_Stream;              //!< 送受信用ストリームです。
#else
    nw::snd::internal::fnd::HioStream m_Stream; //!< 送受信用ストリームです。
    u32 m_FrameCount;
#endif
};

} // namespace nw::snd::edit::internal
} // namespace nw::snd::edit
} // namespace nw::snd
} // namespace nw

#if defined(NW_PLATFORM_CTR)
#if NN_CURRENT_VERSION_NUMBER >= NN_VERSION_NUMBER(4,0,0,0)
#pragma diag_default 1301 // padding inserted in struct.
#pragma diag_default 2530 // padding added to end of struct.
#endif
#endif

#endif // NW_SND_CONFIG_ENABLE_DEV

#endif // NW_SND_EDIT_HIO_STREAM_H_
