﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_SND_DW_INTERNAL_WAVE_GRAPH_H_
#define NW_SND_DW_INTERNAL_WAVE_GRAPH_H_

#include <nw/dw/control/dw_UIElement.h>
#include <nw/dev/dev_PrimitiveRenderer.h>

namespace nw {
namespace snd {
namespace dw {
namespace internal {

//---------------------------------------------------------------------------
//! @briefprivate
//---------------------------------------------------------------------------
class WaveGraph : public nw::internal::dw::UIElement
{
private:
    typedef nw::internal::dw::UIElement Base;

    static const s32 INVALID_INDEX = SHRT_MIN;

    struct ValueRange
    {
        f32 min;
        f32 max;
        f32 first;
        f32 last;
    };

    class CacheManager
    {
    public:
        CacheManager();

    public:
        void SetBuffer(s16* pBuffer, u32 bufferLength);

        ValueRange* GetCache(s32 logicalIndex) const;
        ValueRange* GetNextWriteCache() const;
        s32 GetWriteIndex() const { return m_WriteIndex; }
        s32 GetValidLength() const { return m_ValidLength; }

        void IncrementWriteIndex();
        void Clear();

    private:
        inline s32 GetPhysicalIndex(s32 logicalIndex) const;

    private:
        ValueRange* m_pData;
        s32 m_DataLength;
        s32 m_ValidLength;
        s32 m_WriteIndex;
    };

public:
    WaveGraph();

    void Initialize(nw::ut::IAllocator& allocator);
    void Finalize();
    u32 GetRequiredDrawBufferSize() const;

    void SetWaveData(const s16* pWaveData, u32 waveDataSize);
    void SetWaveDataStartIndex(u32 value);

    u32 GetRequiredWaveCacheSize();
    void SetWaveCacheBuffer(s16* pBuffer, u32 bufferSize);

    u32 GetSamplesPerSec() const;
    void SetSamplesPerSec(u32 value);

    f32 GetScaleX() const;
    void SetScaleX(f32 value);

protected:
    /*override*/ void OnUpdate(const nw::internal::dw::UIElementTreeContext& context);
    /*override*/ void OnRender(const nw::internal::dw::UIElementTreeContext& context, nw::internal::dw::UIRenderer& renderer, nw::internal::dw::UIElementRenderArgs& args) const;

private:
    void CacheValueRanges();
    void UpdateDrawBuffer();

    inline void GetValueRange(s32 index, s32 samples, f32 yScale, WaveGraph::ValueRange& valueRange) const;
    inline s32 ValidateIndex(s32 logicalIndex) const;
    inline f32 ValueToYPosition(s16 value, f32 scale) const;
    inline bool IsValidWaveData() const;

private:
    const s16* m_pWaveData;
    s32 m_WaveDataSize;
    s32 m_WaveDataStartIndex;
    s32 m_WaveDataCachedIndex;

    nw::dev::DrawBuffer m_DrawBuffer;
    nw::ut::IAllocator* m_pAllocator;

    CacheManager m_CacheManager;

    u32 m_SamplesPerSec;
    f32 m_ScaleX;

#if defined(NW_DEBUG) || defined(NW_DEVELOP)
public:
    /*override*/ const char* ToString() const
    {
        return "WaveGraph";
    }
#endif
};

} // internal
} // dw
} // snd
} // nw

#endif // NW_SND_DW_INTERNAL_WAVE_GRAPH_H_
