﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_SND_CTRL_PLAY_SOUND_HANDLER_H_
#define NW_SND_CTRL_PLAY_SOUND_HANDLER_H_

#include <nw/snd/snd_Config.h>
#ifdef NW_SND_CONFIG_ENABLE_DEV

#include <nw/snd/edit/hio/sndedit_HioProtocol.h>
#include <nw/snd/edit/hio/sndedit_HioMessageHandler.h>
#include <nw/snd/ctrl/protocol/sndctrl_PlaySoundPacket.h>

namespace nw {
namespace snd {
namespace ctrl {

class SoundObjectController;

namespace internal {

class HioPacketStream;

class PlaySoundHandler :
    public edit::internal::HioMessageHandlerImpl<edit::internal::HIO_MESSAGE_PLAY_SOUND, PlaySoundPacket>
{
public:
    PlaySoundHandler() : m_SoundObjectController(NULL) { }
    virtual ~PlaySoundHandler() { }

public:
    void SetSoundObjectController(SoundObjectController* connectionController);

protected:
    //---------------------------------------------------------------------------
    //! @brief         読み込み済みの対象HIOメッセージを処理します。
    //!
    //! @param[in]     packet  HIO パケットを指定します。
    //! @param[in]     stream  返信用の出力ストリームを指定します。
    //!
    //! @return        HIOメッセージの処理結果を返します。
    //---------------------------------------------------------------------------
    virtual edit::internal::HioResult OnInvokeForReadTargetPacket(
        const PlaySoundPacket& packet,
        edit::internal::HioPacketStream& stream);

private:
    SoundObjectController* m_SoundObjectController;
};

} // namespace nw::snd::ctrl::internal
} // namespace nw::snd::ctrl
} // namespace nw::snd
} // namespace nw

#endif // NW_SND_CONFIG_ENABLE_DEV

#endif // NW_SND_CTRL_PLAY_SOUND_HANDLER_H_
