﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_MATH_CONFIG_H_
#define NW_MATH_CONFIG_H_

#include <nw/types.h>

#define NW_MATH_WARNING NW_WARNING
#define NW_MATH_REPORT NW_LOG

#ifndef NW_MATH_MINMAXLT_ASSERT
#define NW_MATH_MINMAXLT_ASSERT(exp, min, max) \
            NW_ASSERTMSG( (exp) >= (min) && (exp) < (max), #exp " is out of bounds(%d)\n%d <= "#exp" < %d not satisfied.", static_cast<int>(exp), static_cast<int>(min), static_cast<int>(max))
#endif

#define NW_MATH_AS_INLINE

#if defined(NW_MATH_AS_INLINE)
  #define NW_MATH_INLINE inline
#else
  #define NW_MATH_INLINE
#endif



#if defined( NW_HARDWARE_CTR ) && ! defined( NW_BUILD_NOOPT )

#if ! defined( NW_MATH_UNUSE_ASM ) && ! defined( NW_MATH_USE_ASM )
  #define NW_MATH_USE_ASM
#endif

#endif

// intrinsics 版コードをビルドする。
#if ! defined(NW_MATH_DISABLE_INTRINSICS) && ! defined(NW_MATH_ENABLE_INTRINSICS)
  #if defined(NW_PLATFORM_CAFE) && __GHS_VERSION_NUMBER >= 536
    #define NW_MATH_ENABLE_INTRINSICS
  #endif
#endif

// intrinsics 版を標準として使用する。
#if ! defined(NW_MATH_UNUSE_INTRINSICS) && ! defined(NW_MATH_USE_INTRINSICS)
  #if defined(NW_MATH_ENABLE_INTRINSICS)
    #define NW_MATH_USE_INTRINSICS
  #endif
#endif

#ifndef NW_MATH_IMPL_NS
  #if defined(NW_MATH_USE_INTRINSICS)
    #define NW_MATH_IMPL_NS ::nw::math::internal::intrinsics
  #else
    #define NW_MATH_IMPL_NS ::nw::math::internal::standard
  #endif
#endif

#if defined(NW_MATH_ENABLE_INTRINSICS)

namespace nw { namespace math { namespace internal {

inline f32x2& tof32x2(f32& x)
{
    return *reinterpret_cast<f32x2*>(&x);
}

inline const f32x2& tof32x2(const f32& x)
{
    return *reinterpret_cast<const f32x2*>(&x);
}

inline f32x2* tof32x2(f32* x)
{
    return reinterpret_cast<f32x2*>(x);
}

inline const f32x2* tof32x2(const f32* x)
{
    return reinterpret_cast<const f32x2*>(x);
}

}}} // namespace nw::math::internal

#endif // NW_MATH_ENABLE_INTRINSICS

/* NW_MATH_CONFIG_H_ */
#endif
