﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_LYT_SHADERCONTAINER_H_
#define NW_LYT_SHADERCONTAINER_H_

#include <nw/ut/ut_LinkList.h>

#include <nw/lyt/lyt_Types.h>

namespace nw
{
namespace lyt
{

//---------------------------------------------------------------------------
// シェーダを保持するクラスです。
//
// sa ShaderContainer
//
//---------------------------------------------------------------------------

//! @brief 内部用機能のため使用禁止です。
class ShaderRefLink
{
    NW_DISALLOW_COPY_AND_ASSIGN(ShaderRefLink);

public:

    //----------------------------------------
    //! @name コンストラクタ／デストラクタ
    //@{

    // コンストラクタです。

    //! @brief 内部用機能のため使用禁止です。
    ShaderRefLink();


    // デストラクタです。

    //! @brief 内部用機能のため使用禁止です。
    ~ShaderRefLink();

    // @}

    //----------------------------------------
    //! @name 設定／取得
    //@{

    // シェーダ名を設定します。

    //! @brief 内部用機能のため使用禁止です。
    //!
    //! @param[in] resourceName シェーダを特定する名前です。
    //!
    void SetName(
        const char* resourceName);

    // シェーダのリソース名を取得します。

    //! @brief 内部用機能のため使用禁止です。
    //!
    //! @return シェーダのリソース名を返します。
    //!
    const char* GetResourceName() const
    {
        return m_Name;
    }

    // シェーダ情報を取得します。

    //! @brief 内部用機能のため使用禁止です。
    //!
    //! @return シェーダ情報を返します。
    //!
    ArchiveShaderInfo& GetShaderInfo()
    {
        return m_ShaderInfo;
    }

    // シェーダ情報を取得します。

    //! @brief 内部用機能のため使用禁止です。
    //!
    //! @return シェーダ情報を返します。
    //!
    const ArchiveShaderInfo& GetShaderInfo() const
    {
        return m_ShaderInfo;
    }

    // @}

    // リンク情報です。

    //! @brief 内部用機能のため使用禁止です。
    ut::LinkListNode m_Link;

private:
    char m_Name[ShaderNameMax];
    ArchiveShaderInfo m_ShaderInfo;
};

//---------------------------------------------------------------------------
//! @brief シェーダを保持するクラスです。
//!
//! @sa ResourceAccessor
//!
//---------------------------------------------------------------------------
class ShaderContainer : public ut::LinkList<ShaderRefLink, offsetof(ShaderRefLink, m_Link)>
{
    NW_DISALLOW_COPY_AND_ASSIGN(ShaderContainer);

public:
    //----------------------------------------
    //! @name コンストラクタ／デストラクタ
    //@{

    //! @brief コンストラクタです。
    //!
    ShaderContainer() {}

    //! @brief デストラクタです。
    //!
    //! @details
    //! 登録されているすべてのシェーダを破棄します。
    //!
    ~ShaderContainer();

    //@}

    //----------------------------------------
    //! @name 登録／破棄
    //@{

    //! @brief 登録を抹消します。
    //!
    //! @details
    //! 登録されているすべてのシェーダを破棄します。
    //!
    void Finalize();

    //! @brief シェーダ情報を登録します。
    //!
    //! @param[in] name シェーダの名前です。
    //!
    //! @return シェーダ情報です。メモリ確保できない場合には NULL が返ります。
    //!
    ArchiveShaderInfo* RegistShader(const char* name);

    //! @brief シェーダの登録を抹消します。
    //!
    //! @param[in] info シェーダ情報です。
    //!
    void UnregistShader(ArchiveShaderInfo* info);

    //@}

    //----------------------------------------
    //! @name 検索
    //@{

    //! @brief シェーダ情報を検索します。
    //!
    //! @param[in] name シェーダのリソース名です。
    //!
    //! @return
    //! シェーダ情報を返します。
    //!
    const ArchiveShaderInfo* FindShaderByName(const char* name) const;

    //@}
};

} // namespace nw::lyt
} // namespace nw

#endif // NW_LYT_SHADERCONTAINER_H_
