﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nw/config.h>

#if defined(NW_PLATFORM_WIN32)

#pragma warning ( push )
    #pragma  warning ( disable : 4189 )
    #pragma  warning ( disable : 4100 )
    #pragma  warning ( disable : 4063 )
    #include <texUtils.h>
#pragma warning ( pop )

namespace nw {
namespace font {
namespace internal {

    class TextureTilingConverterImpl;

    class TextureTilingConverter
    {
        static TextureTilingConverterImpl* m_pImpl;
    public:
        static BOOL Initialize(TC2Config& config);
        static BOOL ConvertTiling(GX2Surface& src, GX2Surface& dst);
        static BOOL DestorySurface(GX2Surface& surface);
        static BOOL Finalize();
    };
}
}
}

#endif // NW_PLATFORM_WIN32
