﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

//--------------------------------------------------------------------------------
// EffectMakerからのランタイム利用
//--------------------------------------------------------------------------------
#ifdef _EFT_TOOL

#include <memory.h>
#include <stdio.h>
#include <string.h>
#include <malloc.h>
#include <stdarg.h>

#include "eft2_Tool.h"

#define EFT_IS_WIN                  (TRUE)
#define EFT_IS_CAFE                 (FALSE)
#define EFT_OPENGL                  (TRUE)
#define EFT_GX2                     (FALSE)
#define EFT_OGL
#define EFT_UNUSED_VARIABLE(Variable) (void)(&Variable);

#define EFT_ENDIAN_TYPE             (0)
#define EFT_ENDIAN_LITTLE
#define EFT_BI_ENDIAN
#define EFT_USE_UNIFORM_BLOCK
#define EFT_USE_INSTANS_DRAW

#else

#include <nw/sys.h>

//--------------------------------------------------------------------------------
// Windows / OpenGL
//--------------------------------------------------------------------------------
#if defined( NW_PLATFORM_WIN32 ) || defined( NW_USE_NINTENDO_SDK )

#include <memory.h>
#include <stdio.h>
#include <string.h>
#include <malloc.h>

// ターゲット
#define EFT_IS_WIN                  (TRUE)
#define EFT_IS_CAFE                 (FALSE)

// エンディアン
#define EFT_ENDIAN_TYPE             (0)
#define EFT_ENDIAN_LITTLE
#define EFT_BI_ENDIAN

// 利用するグラフィックスライブラリ
#define EFT_OPENGL                  (TRUE)
#define EFT_GX2                     (FALSE)
#define EFT_GFX                     (FALSE)

// シェーダをランタイム上でコンパイルする
#define EFT_ONLINE_SHADER_COMPILE

//-------------------------------------------------------
// OpenGL
//-------------------------------------------------------
#if EFT_OPENGL
#include <gl/glew.h>

#define EFT_OGL

// GPUへのデータ転送
#define EFT_USE_UNIFORM_BLOCK

// レンダラ
#define EFT_USE_INSTANS_DRAW

// プリミティブタイプ 0:QUADS 1:TRIANGLE_STRIP
#define EFT_PARTICLE_PRIM_TRIANGLES_MODE    (0)

#endif  // EFT_OPENGL


#if defined( NW_PLATFORM_SMART_DEVICE )

#define EFT_OPENGLES2               (TRUE)

//-------------------------------------------------------
// OpenGL ES2.0
//-------------------------------------------------------
#if EFT_OPENGLES2
#include <gl/glew.h>

#define EFT_OGL

// 機能削減版スペック
#define EFT_DEGRADATION_SPEC

// GPUへのデータ転送
#define EFT_USE_UNIFORM_REGISTER

// レンダラ
//#define EFT_USE_REGISTER_DRAW
#define EFT_USE_INSTANS_DRAW

// プリミティブタイプ 0:QUADS 1:TRIANGLE_STRIP
#define EFT_PARTICLE_PRIM_TRIANGLES_MODE    (1)

#endif
#endif


// テクスチャ
namespace nw	{
namespace eft2	{
typedef GLuint TextureInterface;
typedef GLuint TextureSamplerInterface;
typedef TextureInterface _TexInterface;
typedef TextureSamplerInterface _SamplerInterface;
}}


// OpenGLエラーチェック
#ifdef EFT_OGL
#ifdef _DEBUG
#define EFT_GLERR_CHECK() { GLenum e = glGetError(); EFT_ASSERT_MSG( e == GL_NONE, "GL_ERR: 0x%x", e ); }
#else
#define EFT_GLERR_CHECK() ((void)0)
#endif
#endif

#endif  // NW_PLATFORM_WIN32




//--------------------------------------------------------------------------------
// Cafe / GX2
//--------------------------------------------------------------------------------
#if defined( NW_PLATFORM_CAFE )

#include <types.h>
#include <cafe/demo.h>
#include <cafe/gx2.h>

// ターゲット
#define EFT_IS_CAFE                 (TRUE)
#define EFT_IS_WIN                  (FALSE)

// エンディアン
#define EFT_ENDIAN_TYPE             (1)
//#define EFT_BI_ENDIAN

// 利用するグラフィックスライブラリ
#define EFT_GX2                     (TRUE)
#define EFT_OPENGL                  (FALSE)
#define EFT_GFX                     (FALSE)

// GPUへのデータ転送
#define EFT_USE_UNIFORM_BLOCK

// レンダラ
#define EFT_USE_INSTANS_DRAW

// オフラインシェーダコンパイル
#define EFT_OFFLINE_SHADER_COMPILE

// テクスチャ
namespace nw	{
namespace eft2	{
typedef const GX2Texture* TextureInterface;
typedef const GX2Sampler* TextureSamplerInterface;
typedef TextureInterface _TexInterface;
typedef TextureSamplerInterface _SamplerInterface;
}}

// プリミティブタイプ
// 1 にした場合パーティクルの描画を GL_TRIANGLE_STRIP で行う。0の場合、GL_QUADS で描画する。
#define EFT_PARTICLE_PRIM_TRIANGLES_MODE    (0)


#endif  // NW_PLATFORM_CAFE



#if defined( NW_PLATFORM_SMART_DEVICE )
#ifndef NW_PLATFORM_WIN32
//--------------------------------------------------------------------------------
// SmartDevice / OpenGL ES2.0
//--------------------------------------------------------------------------------

#include <memory.h>
#include <stdio.h>
#include <string.h>
#if defined(ANDROID)
#include <cmath>
#include <android/log.h>
#endif

#include <nw/types.h>

#if defined(ANDROID)
#include <GLES2/gl2.h>
#include <GLES2/gl2ext.h>
#else
#include <OpenGLES/ES2/gl.h>
#include <OpenGLES/ES2/glext.h>
#endif

// ターゲット
#define EFT_IS_WIN                  (0)
#define EFT_IS_CAFE                 (0)
#define EFT_IS_IOS                  (1)

// エンディアン
#define EFT_ENDIAN_TYPE             (0)
#define EFT_ENDIAN_LITTLE
#define EFT_BI_ENDIAN

// 利用するグラフィックスライブラリ
#define EFT_OPENGL                  (FALSE)
#define EFT_OPENGLES2               (TRUE)
#define EFT_GX2                     (FALSE)
#define EFT_GFX                     (FALSE)

#define EFT_OGL
#define EFT_ONLINE_SHADER_COMPILE

// 機能削減版スペック
#define EFT_DEGRADATION_SPEC

// GPUへのデータ転送
#define EFT_USE_UNIFORM_REGISTER

// レンダラ
#if defined(ANDROID)
#define EFT_USE_REGISTER_DRAW       // Android向け
#else
#define EFT_USE_INSTANS_DRAW        // iOS向け
#endif
// テクスチャ
namespace nw	{
namespace eft2	{
typedef GLuint TextureInterface;
typedef GLuint TextureSamplerInterface;
typedef TextureInterface _TexInterface;
typedef TextureSamplerInterface _SamplerInterface;
}}

// プリミティブタイプ
// 1 にした場合パーティクルの描画を GL_TRIANGLE_STRIP で行う。0の場合、GL_QUADS で描画する。
#define EFT_PARTICLE_PRIM_TRIANGLES_MODE    (1)

// OpenGLエラーチェック
#ifdef _DEBUG
//#define EFT_GLERR_CHECK() { GLenum e = glGetError(); printf( e == GL_NONE, "GL_ERR: 0x%x\n", e ); }
#define EFT_GLERR_CHECK() ((void)0)
#else
#define EFT_GLERR_CHECK() ((void)0)
#endif

#if defined(ANDROID)
namespace std {
#define fabsf             fabs
#define expf              exp
#define logf              log
#define log10f            log10
#define fmodf             fmod
#define modff             modf
#define ceilf             ceil
#define floorf            floor
#define sqrtf             sqrt
#define acosf             acos
#define asinf             asin
#define atanf             atan
#define atan2f            atan2
#define sinf              sin
#define cosf              cos
#define tanf              tan
#define cosf              cos
}

typedef int errno_t;
#endif

// NW_PLATFORM_WIN32
#endif

// NW_PLATFORM_SMART_DEVICE
#endif


//--------------------------------------------------------------------------------
// プラットフォーム共通
//--------------------------------------------------------------------------------
#include <assert.h>
#include <math.h>
#include <nw/math/math_Types.h>

#define USE_NW_EFFECT                       (TRUE)
#define EFT_UNUSED_VARIABLE                 NW_UNUSED_VARIABLE
#define EFT_NULL_ASSERT                     NW_NULL_ASSERT
#define EFT_ASSERT_VALID_POINTER            NW_ASSERT_VALID_POINTER
#define EFT_PRINT                           NW_LOG
#define EFT_ERR                             NW_ERR
#define EFT_WARNING                         NW_WARNING
#define EFT_ASSERT                          NW_ASSERT
#define EFT_ASSERT_MSG                      NW_ASSERTMSG
#define EFT_ASSERT_IS_NOT_STACK(ADDR)
#define EFT_PARTICLE_PRIM_VERTICES_NUM      (4)
#define EFT_PARTICLE_PRIM_INDICES_NUM       (4)
#define EFT_PARTICLE_PRIM_PRIMITIVE_NUM     (1)

#endif
