﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nw/eft/typeDef2.h>
//------------------------------------------------------------------------------
namespace nw {
namespace eftvw2 {

//---------------------------------------------------------------------------
//! @brief        エフェクトビューア用の簡易文字列クラス。
//---------------------------------------------------------------------------
struct TexWriter
{
    //---------------------------------------------------------------------------
    //! @brief        コンストラクタです。
    //---------------------------------------------------------------------------
    TexWriter()
    {
        mBasePosX = 0.0f;
        mBasePosY = 0.0f;
    }

    //---------------------------------------------------------------------------
    //! @brief        デストラクタです。
    //---------------------------------------------------------------------------
    virtual ~TexWriter() {}

    //---------------------------------------------------------------------------
    //! @brief        指定位置にデバッグ文字を出力します。
    //! @param[in] posX     x座標
    //! @param[in] posY     y座標
    //! @param[in] format   文字列フォーマット
    //---------------------------------------------------------------------------
    virtual void Printf( f32 posX, f32 posY, const char* format, ... )
    {
        EFT_UNUSED_VARIABLE( posX );
        EFT_UNUSED_VARIABLE( posY );
        EFT_UNUSED_VARIABLE( format );
    }

protected:
    f32 mBasePosX;      //!< TBD
    f32 mBasePosY;      //!< TBD
};

//------------------------------------------------------------------------------
} // namespace eftvw2
} // namespace nw
