﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nw/eft/eft2_Enum.h>
#include <nw/eft/eft2_Heap.h>

namespace nw     {
namespace eftvw2 {

//---------------------------------------------------------------------------
//! @brief  ファイルの読み込み・書き出し
//---------------------------------------------------------------------------
class FileSystem
{
public:
    //---------------------------------------------------------------------------
    //! @brief  ファイル読み込み処理です。
    //! @param[in] eftHeap     TBD
    //! @param[in] fileName     TBD
    //! @param[in] retBuffer     TBD
    //! @param[in] retBufferSize     TBD
    //! @param[in] alignment     TBD
    //! @return TBD
    //---------------------------------------------------------------------------
    static bool Load( nw::eft2::Heap*   eftHeap,
                      const char*       fileName,
                      void**            retBuffer,
                      u32*              retBufferSize,
                      u32               alignment = nw::eft2::EFT_PTCL_BINARY_ALIGNMENT );

    //---------------------------------------------------------------------------
    //! @brief  ファイル書き出し処理です。
    //! @param[in] fileName     TBD
    //! @param[in] buffer     TBD
    //! @param[in] size     TBD
    //! @param[in] count     TBD
    //! @param[in] isBinary     TBD
    //---------------------------------------------------------------------------
    static void Write( const char* fileName, void *buffer, u32 size, u32 count, bool isBinary );
};

} // namespace eftvw2
} // namespace nw
