﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <types.h>
#include <nw/eft/eftcom_Message.h>
#include <nw/eft/eftcom_Protocol.h>

#if EFT_IS_WIN
#include <windows.h>
#endif

#include <nw/eft/eftvw2_ToolConnecter.h>
#include <nw/eft/eftvw2_CmdReceiver.h>

namespace nw    {
namespace eftvw2  {

//------------------------------------------------------------------------------
//! @brief コマンド送信クラス
//------------------------------------------------------------------------------
class CmdSender
{
        friend class ToolConnecter;

public:
    //---------------------------------------------------------------------------
    //! @brief        コンストラクタ
    //---------------------------------------------------------------------------
    CmdSender()
    {
 //       ClearToolName();
    }

    //---------------------------------------------------------------------------
    //! @brief        コンストラクタ
    //! @param[in] heap     TBD
    //! @param[in] buffSize     TBD
    //---------------------------------------------------------------------------
    CmdSender( nw::eft2::Heap* heap, size_t buffSize );


    //---------------------------------------------------------------------------
    //! @brief        デストラクタ
    //---------------------------------------------------------------------------
    virtual ~CmdSender();


    //---------------------------------------------------------------------------
    //! @brief        コマンドを送信する
    //! @param[in] type     TBD
    //! @param[in] buffer     TBD
    //! @param[in] size     TBD
    //---------------------------------------------------------------------------
    virtual void SendCommand( nw::eftcom::MESSAGE_TYPE type, void* buffer, u32 size );


    //---------------------------------------------------------------------------
    //! @brief        接続先のエフェクトメーカーを検索する
    //---------------------------------------------------------------------------
    virtual void SearchEffectMaker(){}


    //---------------------------------------------------------------------------
    //! @brief        接続したいツール名を設定します。
    //---------------------------------------------------------------------------
   // void SetToolName(const char* connectedToolName )
   // {
   //     nw::ut::strncpy(
   //         mToolName, ProtocolEM4F::NString32::MAX_STRING,
   //         connectedToolName, ProtocolEM4F::NString32::MAX_STRING );
   // }


    //---------------------------------------------------------------------------
    //! @brief        接続ツールをクリアします。
    //---------------------------------------------------------------------------
  //  void ClearToolName()
  //  {
  //      mToolName[0] = 0;
  //  }


    //---------------------------------------------------------------------------
    //! @brief        送信コマンドを追加します。
    //! @param[in] buffer     TBD
    //! @param[in] size     TBD
    //---------------------------------------------------------------------------
    void AddCommand( const void* buffer, u32 size );


    //---------------------------------------------------------------------------
    //! @brief        送信コマンドをpopします。
    //! @return TBD
    //---------------------------------------------------------------------------
    void PopCommand();


    //---------------------------------------------------------------------------
    //! @brief        現在の送信コマンドを取得
    //! @return TBD
    //---------------------------------------------------------------------------
    Cmd* GetCommand();

public:
    static CmdSender*       gCmdSender;         //!< TBD
protected:
    nw::eft2::Heap*         mHeap;              //!< TBD
private:
    CmdFixedArray			mCmdQueue;          //!< ビューアコマンドキュー
    static nw::ut::Mutex	s_Mutex;            //!< TBD
    u8*                     mSharedBuffer;      //!< TBD
    size_t                  mSharedBufferSize;  //!< TBD
};


//------------------------------------------------------------------------------
//! @brief              コマンド送信クラスを生成する
//! @param[in] heap     ヒープへのポインタ
//! @param[in] buffSize バッファサイズ
//! @return             コマンド送信クラスへのポインタ
//------------------------------------------------------------------------------
CmdSender* CreateCmdSender( nw::eft2::Heap* heap, size_t buffSize );


//------------------------------------------------------------------------------
//! @brief  コマンド送信クラスを取得する
//! @return コマンド送信クラスへのポインタ
//------------------------------------------------------------------------------
CmdSender* GetCmdSender();


//------------------------------------------------------------------------------
//! @brief  コマンド送信クラスを破棄する
//! @param[in] heap     ヒープへのポインタ
//------------------------------------------------------------------------------
void DestroyCmdSender( nw::eft2::Heap* heap );


} // namespace eftvw2
} // namespace nw
