﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nw/eft/eft2_Enum.h>
#include <nw/eft/eft2_Data.h>

namespace nw   {
namespace eft2 {

//---------------------------------------------------------------------------
// レンダコンテキストクラス
//---------------------------------------------------------------------------
class Rendercontext
{
public:
    //---------------------------------------------------------------------------
    //! @brief      コンストラクタ
    //---------------------------------------------------------------------------
    Rendercontext(){};

    //---------------------------------------------------------------------------
    //! @brief      デストラクタ
    //---------------------------------------------------------------------------
    ~Rendercontext(){};

    //---------------------------------------------------------------------------
    //! @brief                       ResRenderStateの内容をセットする
    //! @param[in] resRenderState    セットするResRenderStateへのポインタ
    //! @param[in] colorBufferEnable カラーバッファ書き込みの有効無効
    //---------------------------------------------------------------------------
    static void SetRenderStateResource( ResRenderState* resRenderState, bool colorBufferEnable );

    //---------------------------------------------------------------------------
    //! @brief                  ブレンドタイプのセットアップ
    //! @param[in] blend                ブレンドタイプのON/OFF
    //! @param[in] blendType            ブレンドタイプの指定
    //! @param[in] colorBufferEnable  カラーバッファ書き込みの有効無効
    //---------------------------------------------------------------------------
    static void SetBlendType( bool blend, BlendType blendType, bool colorBufferEnable );

    //---------------------------------------------------------------------------
    //! @brief                  Zバッファのセットアップ
    //! @param[in] test         ZバッファのON/OFF
    //! @param[in] write        Zバッファへの書き込みのON/OFF
    //! @param[in] func         比較関数の指定
    //---------------------------------------------------------------------------
    static void SetZBufferCtrl( bool test, bool write, CompareFunc func );

    //---------------------------------------------------------------------------
    //! @brief                      αテストタイプのセットアップ
    //! @param[in] enable           αテストのON/OFF
    //! @param[in] alphaThreshold   αテスト値
    //! @param[in] func             比較関数の指定
    //---------------------------------------------------------------------------
    static void SetAlphaTest( bool enable, f32 alphaThreshold, CompareFunc func );

    //------------------------------------------------------------------------------
    //! @brief                      表示面のセットアップ
    //! @param[in] displaySideType  表示面のタイプ
    //------------------------------------------------------------------------------
    static void SetDisplaySideType( DisplaySideType displaySideType );
};

} // namespace nw
} // namespace eft2
