﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_DW_WINDOW_MENU_H_
#define NW_DW_WINDOW_MENU_H_

#include <nw/types.h>
#include <nw/dw/window/dw_Window.h>

namespace nw {
namespace internal {
namespace dw {

class Pad;

namespace detail {

class WindowMenu : private Window
{
public:
    /* implicit */ WindowMenu( WindowList& windowList );
    ~WindowMenu();

    void SetCurrentWindowIndex( int index ) { m_CurrentWindowIndex = index; }
    int GetCurrentWindowIndex() const { return m_CurrentWindowIndex; }

    bool Create( f32 x, f32 y ) { return Window::Create( x,y ); }
    void SetPosition( const nw::math::Vector2& pos ) { Window::SetPosition( pos ); }
    void SetSize( const nw::math::Vector2& size ) { Window::SetSize( size ) ;}

    void Draw(WindowContext& context, UIRenderer& renderer) { Window::Draw(context, renderer); }
    void UpdateInputs(const nw::internal::dw::Inputs& inputs) { Window::UpdateInputs(inputs); }

private:
    virtual void OnDraw(IUIRenderContext& context, UIRenderer& renderer);
    virtual void OnUpdateInputs(const nw::internal::dw::Inputs& inputs);

    Window* GetSelectWindow();
    Window* GetWindow( int windowIndex );
    void ExchangeWindowIndex( int index1, int index2 );
    void ScrollToEnsureVisible( int windowIndex, f32 cyChar );
    void DrawScrollMark( IUIRenderContext& context, UIRenderer& renderer, f32 cyChar );

    WindowList& m_WindowList;
    int m_CurrentWindowIndex;
    int m_GrabWindowIndex;
    int m_ScrollOffset;

    void* m_TextGfxBuffer;
    font::DispStringBuffer* m_TextBuffer;
};

} // detail

} // dw
} // internal
} // nw

#endif // NW_DW_WINDOW_MENU_H_
