﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_DW_CONFIG_H_
#define NW_DW_CONFIG_H_

#include <nw/dw/system/dw_NwTypeUtility.h>

#include <nw/ut/ut_Color.h>

namespace nw {
namespace internal {
namespace dw {
namespace internal {

// Windowのデフォルトカラーなど、定数をまとめたクラスです。
//
class WindowConfig
{
public:
    // インスタンスの取得
    static const WindowConfig& GetInstance()
    {
        static WindowConfig s_Instance;
        return s_Instance;
    }

    // 設定可能なインスタンスの取得
    // アプリケーションでこの関数を経由して設定を変更することで、
    // dwライブラリの見た目をカスタマイズすることが可能です。
    static WindowConfig& GetModifiableInstance()
    {
        const WindowConfig& c = WindowConfig::GetInstance();
        WindowConfig* pInstance = const_cast<WindowConfig*>(&c);
        return *pInstance;
    }

    const ut::Color4f& GetActiveTitlebarColor0() const { return m_ActiveTitlebarColor0; }
    const ut::Color4f& GetActiveTitlebarColor1() const { return m_ActiveTitlebarColor1; }
    void SetActiveTitlebarColor0(const ut::Color4f& value) { m_ActiveTitlebarColor0 = value; }
    void SetActiveTitlebarColor1(const ut::Color4f& value) { m_ActiveTitlebarColor1 = value; }
    void SetActiveTitlebarColor(const ut::Color4f& value)
    {
        m_ActiveTitlebarColor0 = value;
        m_ActiveTitlebarColor1 = value;
    }

    const ut::Color4f& GetInactiveTitlebarColor0() const { return m_InactiveTitlebarColor0; }
    const ut::Color4f& GetInactiveTitlebarColor1() const { return m_InactiveTitlebarColor1; }
    void SetInactiveTitlebarColor0(const ut::Color4f& value) { m_InactiveTitlebarColor0 = value; }
    void SetInactiveTitlebarColor1(const ut::Color4f& value) { m_InactiveTitlebarColor1 = value; }
    void SetInactiveTitlebarColor(const ut::Color4f& value)
    {
        m_InactiveTitlebarColor0 = value;
        m_InactiveTitlebarColor1 = value;
    }

    const ut::Color4f& GetActiveBorderColor() const { return m_ActiveBorderColor; }
    void SetActiveBorderColor(const ut::Color4f& value) { m_ActiveBorderColor = value; }

    const ut::Color4f& GetInactiveBorderColor() const { return m_InactiveBorderColor; }
    void SetInactiveBorderColor(const ut::Color4f& value) { m_InactiveBorderColor = value; }

    const ut::Color4f& GetActiveTitleColor() const { return m_ActiveTitleColor; }
    void SetActiveTitleColor(const ut::Color4f& value) { m_ActiveTitleColor = value; }

    const ut::Color4f& GetInactiveTitleColor() const { return m_InactiveTitleColor; }
    void SetInactiveTitleColor(const ut::Color4f& value) { m_InactiveTitleColor = value; }

    const ut::Color4f& GetDefaultBackgroundColor0() const { return m_DefaultBackgroundColor0; }
    const ut::Color4f& GetDefaultBackgroundColor1() const { return m_DefaultBackgroundColor1; }
    void SetDefaultBackgroundColor0(const ut::Color4f& value) { m_DefaultBackgroundColor0 = value; }
    void SetDefaultBackgroundColor1(const ut::Color4f& value) { m_DefaultBackgroundColor1 = value; }
    void SetDefaultBackgroundColor(const ut::Color4f& value)
    {
        m_DefaultBackgroundColor0 = value;
        m_DefaultBackgroundColor1 = value;
    }

private:
    WindowConfig() :
       m_ActiveTitlebarColor0(NwTypeUtility::SRGBToLinear(ut::Color4f(0.35f, 0.42f, 0.52f, 1.f))),
       m_ActiveTitlebarColor1(NwTypeUtility::SRGBToLinear(ut::Color4f(0.22f, 0.25f, 0.35f, 1.f))),
       m_InactiveTitlebarColor0(NwTypeUtility::SRGBToLinear(ut::Color4f(0.22f, 0.24f, 0.28f, 1.f))),
       m_InactiveTitlebarColor1(NwTypeUtility::SRGBToLinear(ut::Color4f(0.22f, 0.24f, 0.28f, 1.f))),
       m_ActiveBorderColor(m_ActiveTitlebarColor1),
       m_InactiveBorderColor(m_InactiveTitlebarColor1),
       m_ActiveTitleColor(NwTypeUtility::SRGBToLinear(ut::Color4f::X_WHITE_SMOKE())),
       m_InactiveTitleColor(NwTypeUtility::SRGBToLinear(ut::Color4f(0.7f,  0.7f,  0.7f,  1.f))),
       m_DefaultBackgroundColor0(NwTypeUtility::SRGBToLinear(ut::Color4f(0.13f, 0.16f, 0.20f, 1.f))),
       m_DefaultBackgroundColor1(NwTypeUtility::SRGBToLinear(ut::Color4f(0.13f, 0.16f, 0.20f, 1.f)))
    {}

private:
    ut::Color4f m_ActiveTitlebarColor0;
    ut::Color4f m_InactiveTitlebarColor0;
    ut::Color4f m_ActiveTitlebarColor1;
    ut::Color4f m_InactiveTitlebarColor1;

    ut::Color4f m_ActiveBorderColor;
    ut::Color4f m_InactiveBorderColor;

    ut::Color4f m_ActiveTitleColor;
    ut::Color4f m_InactiveTitleColor;

    ut::Color4f m_DefaultBackgroundColor0;
    ut::Color4f m_DefaultBackgroundColor1;
};

} // namespace internal
} // namespace dw
} // namespace internal
} // namespace nw

#endif // #define NW_DW_CONFIG_H_

