﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nw/dw/system/dw_DrawLineArgs.h>
#include <nw/dw/system/dw_DrawRectangleArgs.h>
#include <nw/dw/system/dw_DrawTextArgs.h>

#if defined(NW_PLATFORM_WIN32) || defined(NW_USE_NINTENDO_SDK)
// TODO: NintendoSdk 対応後、このコメントを削除してください。
#ifdef DrawText
#undef DrawText  // winuser.h で #define されているため #undef します。
#endif
#endif

namespace nw {
namespace dev {
struct DrawBuffer;
}
}

namespace nw {
namespace internal {
namespace dw {

class IUIRenderContext;
struct DrawLineArgs;
struct DrawRectangleArgs;
struct DrawTextArgs;

class UIRenderer
{
protected:
    enum State
    {
        IDLE,
        PRIMITIVE_RENDERING,
        TEXT_WRITING,
    };

public:
    UIRenderer();
    virtual ~UIRenderer() { }

public:
    const nw::math::Matrix44& GetProjectionMatrix() const;
    void SetProjectionMatrix(const nw::math::Matrix44& matrix);

    const nw::math::Matrix34& GetViewMatrix() const;
    void SetViewMatrix(const nw::math::Matrix34& matrix);

    void DrawLine(const DrawLineArgs& arg);
    void DrawLine(const IUIRenderContext* pRenderContext, const DrawLineArgs& arg);
    void DrawLine(const IUIRenderContext* pRenderContext, const DrawMultiLineArgs& arg);
    void DrawRectangle(const DrawRectangleArgs& arg);
    void DrawRectangle(const IUIRenderContext* pRenderContext, const DrawRectangleArgs& arg);
    void FillRectangle(const DrawRectangleArgs& arg);
    void FillRectangle(const IUIRenderContext* pRenderContext, const DrawRectangleArgs& arg);
    void DrawTexture(const DrawRectangleArgs& arg);
    void DrawTexture(const IUIRenderContext* pRenderContext, const DrawRectangleArgs& arg);
    void DrawText(const DrawTextArgs& arg, const char* pText);
    void DrawText(const IUIRenderContext* pRenderContext, const DrawTextArgs& arg, const char* pText);
    void DrawTextFormat(const DrawTextArgs& arg, const char* pFormat, ...);
    void DrawTextFormat(const IUIRenderContext* pRenderContext, const DrawTextArgs& arg, const char* pFormat, ...);
    nw::math::Vector2 MeasureText(const DrawTextArgs& arg, const char* pText);
    nw::math::Vector2 MeasureTextFormat(const DrawTextArgs& arg, const char* pFormat, ...);

    virtual void BeginDraw() { };
    virtual void EndDraw() { };
    virtual void ClearBuffer() { };

protected:
    State GetState() const;
    bool SetState(State state);

    virtual void DrawLineInternal(const IUIRenderContext* pRenderContext, const DrawLineArgs& arg) = 0;
    virtual void DrawLineInternal(const IUIRenderContext* pRenderContext, const DrawMultiLineArgs& arg) = 0;
    virtual void DrawRectangleInternal(const IUIRenderContext* pRenderContext, const DrawRectangleArgs& arg) = 0;
    virtual void FillRectangleInternal(const IUIRenderContext* pRenderContext, const DrawRectangleArgs& arg) = 0;
    virtual void DrawTextureInternal(const IUIRenderContext* pRenderContext, const DrawRectangleArgs& arg) = 0;
    virtual void DrawTextInternal(const IUIRenderContext* pRenderContext, const DrawTextArgs& arg, const char* pText) = 0;
    virtual void DrawTextFormatInternal(const IUIRenderContext* pRenderContext, const DrawTextArgs& arg, const char* pFormat, va_list valist) = 0;
    virtual nw::math::Vector2 MeasureTextInternal(const DrawTextArgs& arg, const char* pText) = 0;
    virtual nw::math::Vector2 MeasureTextFormatInternal(const DrawTextArgs& arg, const char* pFormat, va_list valist) = 0;

    virtual State ChangeState(State state) = 0;

private:
    void SetIdle();

private:
    nw::math::Matrix44 m_ProjectionMatrix;
    nw::math::Matrix34 m_ViewMatrix;

    State m_State;
};

} // dw
} // internal
} // nw
