﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nw/math.h>
#include <nw/dw/system/dw_IUIRenderContext.h>

namespace nw {
namespace internal {
namespace dw {

class UIElement;

class UIElementTreeContext : public IUIRenderContext
{
public:
    /* ctor */ UIElementTreeContext();
    /* dtor */ virtual ~UIElementTreeContext() { }

public:
    const UIElement* PushUIElement(const UIElement& element);
    void PopUIElement(const UIElement* pPreviousElement);

    int GetLevel() const;
    const UIElement* GetCurrentElement() const;

    void OffsetCurrentElementOrigin(const nw::math::Vector2& offset);

    nw::math::Vector2 ScreenToClient(const nw::math::Vector2& position) const;
    nw::math::Vector2 ClientToScreen(const nw::math::Vector2& position) const;

    /* override */ const nw::math::Vector2& GetRenderOffset() const;

private:
    int m_Level;
    const UIElement* m_pCurrenElement;
    nw::math::Vector2 m_UIElementOrigin;
};

} // dw
} // internal
} // nw
