﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nw/dw/system/dw_Types.h>
#include <nw/dw/control/dw_UIElement.h>

namespace nw {
namespace internal {
namespace dw {

class StackPanel : public UIElement
{
private:
    typedef UIElement Base;

    static const f32 SCROLLBAR_SIZE;   // HACK : ★スクロールバーの幅（暫定実装）
    static const nw::ut::Color4f SCROLLBAR_COLOR;

public:
    StackPanel();

    Orientation GetOrientation() const;
    void SetOrientation(Orientation value);

protected:
    /* override */ s32 GetWheelScrollDelta(s32 lines) const;

    //---------------------------------------------------------------------------
    //! @brief       指定子要素が表示されるようにスクロールします。
    //!
    //! @param[in]   element  表示する要素への参照を指定します。
    //---------------------------------------------------------------------------
    /* override */ void OnEnsureVisible(UIElement& element);

    /* override */ bool OnUpdatePointerInput(const nw::internal::dw::Inputs& inputs);
    /* override */ const nw::math::Vector2 OnMeasure(UIRenderer& renderer) const;
    /* override */ void OnUpdate(const UIElementTreeContext& context);
    /* override */ void PreRenderContents(const UIElementTreeContext& context, UIRenderer& renderer, UIElementRenderArgs& args) const;
    /* override */ void PostRenderContents(const UIElementTreeContext& context, UIRenderer& renderer, UIElementRenderArgs& args) const;

    /* override */ bool CanAlignHorizontal(const UIElement& element) const;
    /* override */ bool CanAlignVertical(const UIElement& element) const;

private:
    nw::math::Vector2 MeasureByVertical() const;
    nw::math::Vector2 MeasureByHorizontal() const;

    void UpdateContentsByHorizontal();
    void UpdateContentsByVertical();

    void RenderScrollbarByHorizontal(const UIElementTreeContext& context, UIRenderer& renderer) const;
    void RenderScrollbarByVertical(const UIElementTreeContext& context, UIRenderer& renderer) const;

private:
    Orientation m_Orientation;
};

} // dw
} // internal
} // nw
