﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <string>
#include <nw/dw/control/dw_Label.h>

namespace nw {
namespace internal {
namespace dw {

template<int TTextLength>
class FixedLabel : public Label
{
private:
    typedef Label Base;

public:
    FixedLabel()
    {
        memset(m_Text, 0, sizeof(m_Text));
    }

    virtual ~FixedLabel() { }

public:
    virtual const char* GetText() const { return m_Text; }

    virtual void SetText(const char* value) { return Base::SetText(value); }

    virtual void SetText(const char* value, int length)
    {
        int copyLength = nw::ut::Min(length, TTextLength - 1);

        if(copyLength == 0)
        {
            memset(m_Text, 0, sizeof(m_Text));
            return;
        }

        ut::strncpy(m_Text, value, copyLength);
    }

private:
    char m_Text[TTextLength];

#if defined(NW_DEBUG) || defined(NW_DEVELOP)
private:
    static const u32 DEBUG_TEXT_LENGTH = 32;

public:
    virtual const char* ToString() const
    {
        ut::snprintf(const_cast<char*>(m_DebugText), sizeof(m_DebugText) , sizeof(m_DebugText) - 1, "FixedLabel<%d>", TTextLength);
        return m_DebugText;
    }

private:
    char m_DebugText[DEBUG_TEXT_LENGTH];
#endif
};

} // dw
} // internal
} // nw
