﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_CTRL_DEFAULT_CONTROL_CREATOR_H_
#define NW_CTRL_DEFAULT_CONTROL_CREATOR_H_

#include <nw/lyt/lyt_ControlCreator.h>
#include <nw/ctrl/ctrl_ButtonGroup.h>

namespace nw
{
namespace ctrl
{

//---------------------------------------------------------------------------
//! @brief レイアウトでデフォルトで用意しているコントロールを作成するためのクラスです。
//!
//---------------------------------------------------------------------------
class DefaultControlCreator : public lyt::ControlCreator
{
public:
    //! @brief コンストラクタ
    //!
    //! SetButtonGroup() で ButtonGroup を設定する必要があります。
    //!
    DefaultControlCreator()
        : m_ButtonGroup(NULL)
    {}

    //! @brief コンストラクタ
    //!
    //! @param[in] buttonGroup 生成したコントロールを登録する ButtonGroup を指定します。
    //!
    explicit DefaultControlCreator(ButtonGroup* buttonGroup);

    //! @brief ButtonGroup を設定します。
    //!
    //! @param[in] buttonGroup 生成したコントロールを登録する ButtonGroup を指定します。
    //!
    //! @returns
    //! DefaultControlCreator 自身への参照を返します。
    //!
    //! @sa GetButtonGroup
    //!
    DefaultControlCreator& SetButtonGroup(ButtonGroup* buttonGroup)
    {
        m_ButtonGroup = buttonGroup;
        return *this;
    }

    //! @brief 設定されている ButtonGroup を取得します。
    //!
    //! @returns
    //! 設定されている ButtonGroup へのポインタを返します。
    //!
    //! @sa SetButtonGroup
    //!
    ButtonGroup* GetButtonGroup() const
    {
        return m_ButtonGroup;
    }

    //! @brief 指定されたコントロールソースに対応するコントロールを作成します。
    //!
    //! @details
    //! 現在はボタンのみに対応しています。作成したボタンは、コンストラクタで与えられた
    //! ButtonGroupに格納します。
    //!
    //! @param[in] controlSrc   作成すべきコントロールの情報
    //! @param[in,out] layout   コントロールを作成するレイアウト
    //!
    virtual void CreateControl(const lyt::ControlSrc& controlSrc, lyt::Layout* layout);

protected:
    ButtonGroup* m_ButtonGroup;

};

} // namespace nw::ctrl
} // namespace nw

#endif // NW_CTRL_DEFAULT_CONTROL_CREATOR_H_
