﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief ウェブページ / オフライン HTML で開いたページとのメッセージを通信する為の定数の宣言
 */

#pragma once

namespace nn { namespace web {

/**
 * @brief Session で通信するメッセージの最大サイズです。
 */
static const int SessionMessageSizeMax = 8064;

/**
 * @brief Session で通信するメッセージの種類です。
 */
enum SessionMessageKind
{
    SessionMessageKind_None,   //!< 利用しません。
    SessionMessageKind_Max     //!< 列挙子の総数です。
};

/**
 * @brief Session で通信するメッセージヘッダーです。
 */
struct SessionMessageHeader
{
    uint32_t kind;      //!< メッセージの種類です。
    uint32_t size;      //!< メッセージのサイズです。
    uint64_t _reserved;
};

/**
 * @brief 開いているページから送られたメッセージです。
 */
struct SessionMessage
{
    SessionMessageHeader header;            //!< メッセージヘッダーです。
    NN_ALIGNAS(4) uint8_t body[SessionMessageSizeMax];    //!< メッセージです。
};

/**
 * @brief 開いているページからメッセージが送られた際呼び出されるコールバックの型です。
 */
typedef void (*ReceiveMessageCallback)(const SessionMessage&);

}} // namespace nn::web
