﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
* @file  repair_Types.h
* @brief Repair ライブラリのデータ型や定数の定義です。
*/

#pragma once

#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>

namespace nn { namespace repair {

/**
 * @brief   デバイス ID の文字列長を表します。
 */
const int DeviceIdLength = 20;

/**
 * @brief   デバイス ID の16進文字列長を表します。
 */
const int DeviceIdHexLength = 16;

/**
 * @brief   シリアルナンバーの文字列長を表します。
 */
const int SerialNumberLength = 24;

/**
 * @brief   修理用アーカイブ保存先のディレクトリパスを表します。
 */
static const char* ArchiveDirectoryPath = "NintendoRepairArchive/";

/**
 * @brief   シリアルナンバー保存用ファイルの名前を表します。
 */
static const char* SerialNumberFileName = "SerialNumber.txt";

/**
 * @brief   デバイス ID 保存用ファイルの名前を表します。
 */
static const char* DeviceIdFileName = "DeviceId.txt";

/**
 * @brief   バックアップ済み ID 記録ファイルの名前を表します。
 */
static const char* BackupRecordName = "Backup.log";

/**
 * @brief   リストア済み ID 記録ファイルの名前を表します。
 */
static const char* RestoreRecordName = "Restore.log";

/**
 * @brief   破損 ID 記録ファイルの名前を表します。
 */
static const char* CorruptionRecordName = "Corruption.log";

/**
 * @brief   移行歴ファイルの名前を表します。
 */
static const char* HistoryFileName = "History.log";

/**
 * @brief   設定ファイルの名前を表します。
 */
static const char* ConfigFileName = "NintendoRepair.conf";

/**
 * @brief   メッセージ表示用関数の型です。
 */
typedef void (*ReportFunctionPointer)(const char* message, ...);

/**
 * @brief   メッセージ表示用関数とパラメータの構造体です。
 */
struct ReportCallbackStruct final
{
    ReportFunctionPointer pFunctionBoth;    // console と 画面
    void* pParameterBoth;
    ReportFunctionPointer pFunctionScreen;   // 画面のみ
    void* pParameterScreen;
    ReportFunctionPointer pFunctionConsole;   // console のみ
    void* pParameterConsole;
};

/**
 * @brief   ブラックセーブデータリストの構造体です。
 */
struct BlackListStruct final
{
    nn::Bit64* pIds;
    int count;
};

}} // namespace nn::repair
