﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Result.h>

namespace nn {
    namespace repair {
        //!< SD カードを扱うクラスです。
        class Sdcard final
        {
        public:
            Sdcard() NN_NOEXCEPT
            {}

            //!< アタッチを待ちます。
            nn::Result WaitAttach() NN_NOEXCEPT;

            //!< デタッチを待ちます。
            nn::Result WaitDetach() NN_NOEXCEPT;

        private:
            bool IsInserted() NN_NOEXCEPT;

            nn::Result WaitAttachDetach(bool isWaitAttach) NN_NOEXCEPT;
        };
    }
}

