﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Result.h>
#include <memory>

namespace nn {
    namespace repair
    {
        class IFile
        {
        public:
            virtual ~IFile() {}

            virtual void Close() = 0;
            virtual nn::Result Write(int64_t offset, const void* buffer, size_t size, bool flush) = 0;
            virtual nn::Result Read(size_t* pOut, int64_t offset, void* buffer, size_t size) = 0;
            virtual nn::Result GetSize(int64_t* pOut) = 0;
            virtual nn::Result Flush() = 0;
        };
    }
}
