﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/**
    @file
    @brief      perf モジュール用の、ログを出力する API の宣言です。
*/

#include <nn/nn_Common.h>
#include <nn/diag/detail/diag_DetailStructuredSdkLog.h>

#define NN_DETAIL_PERF_TRACE(...)                   NN_DETAIL_STRUCTURED_SDK_LOG(perf, Trace, 0, ##__VA_ARGS__)
#define NN_DETAIL_PERF_TRACE_V1(...)                NN_DETAIL_STRUCTURED_SDK_LOG(perf, Trace, 1, ##__VA_ARGS__)
#define NN_DETAIL_PERF_TRACE_V2(...)                NN_DETAIL_STRUCTURED_SDK_LOG(perf, Trace, 2, ##__VA_ARGS__)
#define NN_DETAIL_PERF_TRACE_V3(...)                NN_DETAIL_STRUCTURED_SDK_LOG(perf, Trace, 3, ##__VA_ARGS__)

#define NN_DETAIL_PERF_INFO(...)                    NN_DETAIL_STRUCTURED_SDK_LOG(perf, Info, 0, ##__VA_ARGS__)
#define NN_DETAIL_PERF_INFO_V1(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(perf, Info, 1, ##__VA_ARGS__)
#define NN_DETAIL_PERF_INFO_V2(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(perf, Info, 2, ##__VA_ARGS__)
#define NN_DETAIL_PERF_INFO_V3(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(perf, Info, 3, ##__VA_ARGS__)

#define NN_DETAIL_PERF_WARN(...)                    NN_DETAIL_STRUCTURED_SDK_LOG(perf, Warn, 0, ##__VA_ARGS__)
#define NN_DETAIL_PERF_WARN_V1(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(perf, Warn, 1, ##__VA_ARGS__)
#define NN_DETAIL_PERF_WARN_V2(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(perf, Warn, 2, ##__VA_ARGS__)
#define NN_DETAIL_PERF_WARN_V3(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(perf, Warn, 3, ##__VA_ARGS__)

#define NN_DETAIL_PERF_ERROR(...)                   NN_DETAIL_STRUCTURED_SDK_LOG(perf, Error, 0, ##__VA_ARGS__)
#define NN_DETAIL_PERF_ERROR_V1(...)                NN_DETAIL_STRUCTURED_SDK_LOG(perf, Error, 1, ##__VA_ARGS__)
#define NN_DETAIL_PERF_ERROR_V2(...)                NN_DETAIL_STRUCTURED_SDK_LOG(perf, Error, 2, ##__VA_ARGS__)
#define NN_DETAIL_PERF_ERROR_V3(...)                NN_DETAIL_STRUCTURED_SDK_LOG(perf, Error, 3, ##__VA_ARGS__)

#define NN_DETAIL_PERF_FATAL(...)                   NN_DETAIL_STRUCTURED_SDK_LOG(perf, Fatal, 0, ##__VA_ARGS__)
#define NN_DETAIL_PERF_FATAL_V1(...)                NN_DETAIL_STRUCTURED_SDK_LOG(perf, Fatal, 1, ##__VA_ARGS__)
#define NN_DETAIL_PERF_FATAL_V2(...)                NN_DETAIL_STRUCTURED_SDK_LOG(perf, Fatal, 2, ##__VA_ARGS__)
#define NN_DETAIL_PERF_FATAL_V3(...)                NN_DETAIL_STRUCTURED_SDK_LOG(perf, Fatal, 3, ##__VA_ARGS__)

#define NN_DETAIL_PERF_VTRACE(format, args)         NN_DETAIL_STRUCTURED_SDK_VLOG(perf, Trace, 0, format, args)
#define NN_DETAIL_PERF_VTRACE_V1(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(perf, Trace, 1, format, args)
#define NN_DETAIL_PERF_VTRACE_V2(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(perf, Trace, 2, format, args)
#define NN_DETAIL_PERF_VTRACE_V3(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(perf, Trace, 3, format, args)

#define NN_DETAIL_PERF_VINFO(format, args)          NN_DETAIL_STRUCTURED_SDK_VLOG(perf, Info, 0, format, args)
#define NN_DETAIL_PERF_VINFO_V1(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(perf, Info, 1, format, args)
#define NN_DETAIL_PERF_VINFO_V2(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(perf, Info, 2, format, args)
#define NN_DETAIL_PERF_VINFO_V3(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(perf, Info, 3, format, args)

#define NN_DETAIL_PERF_VWARN(format, args)          NN_DETAIL_STRUCTURED_SDK_VLOG(perf, Warn, 0, format, args)
#define NN_DETAIL_PERF_VWARN_V1(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(perf, Warn, 1, format, args)
#define NN_DETAIL_PERF_VWARN_V2(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(perf, Warn, 2, format, args)
#define NN_DETAIL_PERF_VWARN_V3(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(perf, Warn, 3, format, args)

#define NN_DETAIL_PERF_VERROR(format, args)         NN_DETAIL_STRUCTURED_SDK_VLOG(perf, Error, 0, format, args)
#define NN_DETAIL_PERF_VERROR_V1(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(perf, Error, 1, format, args)
#define NN_DETAIL_PERF_VERROR_V2(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(perf, Error, 2, format, args)
#define NN_DETAIL_PERF_VERROR_V3(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(perf, Error, 3, format, args)

#define NN_DETAIL_PERF_VFATAL(format, args)         NN_DETAIL_STRUCTURED_SDK_VLOG(perf, Fatal, 0, format, args)
#define NN_DETAIL_PERF_VFATAL_V1(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(perf, Fatal, 1, format, args)
#define NN_DETAIL_PERF_VFATAL_V2(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(perf, Fatal, 2, format, args)
#define NN_DETAIL_PERF_VFATAL_V3(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(perf, Fatal, 3, format, args)

#define NN_DETAIL_PERF_PUT_TRACE(text, length)      NN_DETAIL_STRUCTURED_SDK_PUT(perf, Trace, 0, text, length)
#define NN_DETAIL_PERF_PUT_TRACE_V1(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(perf, Trace, 1, text, length)
#define NN_DETAIL_PERF_PUT_TRACE_V2(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(perf, Trace, 2, text, length)
#define NN_DETAIL_PERF_PUT_TRACE_V3(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(perf, Trace, 3, text, length)

#define NN_DETAIL_PERF_PUT_INFO(text, length)       NN_DETAIL_STRUCTURED_SDK_PUT(perf, Info, 0, text, length)
#define NN_DETAIL_PERF_PUT_INFO_V1(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(perf, Info, 1, text, length)
#define NN_DETAIL_PERF_PUT_INFO_V2(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(perf, Info, 2, text, length)
#define NN_DETAIL_PERF_PUT_INFO_V3(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(perf, Info, 3, text, length)

#define NN_DETAIL_PERF_PUT_WARN(text, length)       NN_DETAIL_STRUCTURED_SDK_PUT(perf, Warn, 0, text, length)
#define NN_DETAIL_PERF_PUT_WARN_V1(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(perf, Warn, 1, text, length)
#define NN_DETAIL_PERF_PUT_WARN_V2(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(perf, Warn, 2, text, length)
#define NN_DETAIL_PERF_PUT_WARN_V3(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(perf, Warn, 3, text, length)

#define NN_DETAIL_PERF_PUT_ERROR(text, length)      NN_DETAIL_STRUCTURED_SDK_PUT(perf, Error, 0, text, length)
#define NN_DETAIL_PERF_PUT_ERROR_V1(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(perf, Error, 1, text, length)
#define NN_DETAIL_PERF_PUT_ERROR_V2(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(perf, Error, 2, text, length)
#define NN_DETAIL_PERF_PUT_ERROR_V3(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(perf, Error, 3, text, length)

#define NN_DETAIL_PERF_PUT_FATAL(text, length)      NN_DETAIL_STRUCTURED_SDK_PUT(perf, Fatal, 0, text, length)
#define NN_DETAIL_PERF_PUT_FATAL_V1(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(perf, Fatal, 1, text, length)
#define NN_DETAIL_PERF_PUT_FATAL_V2(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(perf, Fatal, 2, text, length)
#define NN_DETAIL_PERF_PUT_FATAL_V3(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(perf, Fatal, 3, text, length)
