﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/** @file
    @brief 一般的な機能
 */

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/account/account_Types.h>
#include <nn/nd/nd_Types.h>

namespace nn { namespace nd {

/**
    @brief      ライブラリを一般向けの権限で初期化します。
*/
void Initialize() NN_NOEXCEPT;

//! @name 送信データの設定に関する機能
//! @{

/**
    @brief      指定したユーザーの送信データに含めるデータを設定します。
    @param[in]  uid ユーザー
    @param[in]  data データ
    @param[in]  dataSize データサイズ
    @pre
                - uid が指すユーザーが本体上に存在する
                - data != nullptr
                - 0 < dataSize <= @ref ApplicationDataSizeMax
*/
void SetApplicationData(const account::Uid& uid, const void* data, size_t dataSize) NN_NOEXCEPT;

/**
    @brief      @ref SetApplicationData で設定したデータを削除します。
    @param[in]  uid ユーザー
    @details    データが設定されていない場合は何もしません。
    @pre
                - uid が指すユーザーが本体上に存在する
*/
void ClearApplicationData(const account::Uid& uid) NN_NOEXCEPT;

//! @}

//! @name 受信データの取得に関する機能
//! @{

//! @}

}} // ~namespace nn::nd
