﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_TimeSpan.h>

namespace nn { namespace nd { namespace detail {

class FirmwareDebugSettings
{
public:
    static void Initialize() NN_NOEXCEPT;
    static bool IsDevelopmentFunctionEnabled() NN_NOEXCEPT;
    static TimeSpan GetSendDataIdRefreshInterval() NN_NOEXCEPT;
private:
    static bool s_IsDevelopmentFunctionEnabled;
    static TimeSpan s_SendDataIdRefreshInterval;
};

}}} // ~namespace nn::nd::detail
