﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_StaticAssert.h>
#include <nn/account/account_Types.h>
#include <nn/nd/nd_NeighborInfoForSystem.h>
#include <nn/nd/nd_TypesForSystem.h>
#include <nn/ndd/ndd_Types.h>
#include <nn/settings/settings_Language.h>
#include <nn/util/util_Optional.h>

namespace nn { namespace nd { namespace detail {

static const Bit8 PayloadVersion = 1;

//! 下層（ndd）で送受信するデータ。ndd::SendDataDescription::data 及び ndd::ReceiveDataDescription::data 部分。
struct Payload
{
    Bit8 version;
    settings::LanguageCode languageCode;
    LocalUserId localUserId;
    bool hasNetworkUserId;
    NetworkUserId networkUserId;
    account::Nickname nickName;
    int recentlyPlayedApplicationCount;
    ncm::ApplicationId recentlyPlayedApplication[RecentlyPlayedApplicationCountMax];
    size_t systemDataSize;
    Bit8 systemData[SystemDataSizeMax];
};
NN_STATIC_ASSERT(sizeof(Payload) <= ndd::SendDataSizeMax);
NN_STATIC_ASSERT(sizeof(Payload) <= ndd::ReceiveDataSizeMax);
NN_STATIC_ASSERT(sizeof(Payload) == 368);

//! 下層（ndd）に渡す送信データを作成する。
void MakeSendDataDescription(
    ndd::SendDataDescription* pOut,
    const ndd::DataId& dataId,
    const settings::LanguageCode& languageCode,
    const LocalUserId& localUserId,
    const util::optional<NetworkUserId>& nsaId,
    const account::Nickname& nickName,
    int recentlyPlayedApplicationCount,
    const ncm::ApplicationId recentlyPlayedApplication[],
    size_t systemDataSize,
    const Bit8 systemData[]
) NN_NOEXCEPT;

//! 下層（ndd）からの受信データから上層（Encounter）向けの受信データを作成する。
bool ParseReceiveDataDescription(nd::NeighborInfoForSystem* pOut, const ndd::ReceiveDataDescription& data) NN_NOEXCEPT;

//! （デバッグ用）上層（Encounter）が期待する受信データから下層（ndd）の受信データを作成する
void MakeReceiveDataDescription(ndd::ReceiveDataDescription* pOut, const nd::NeighborInfoForSystem& info) NN_NOEXCEPT;

}}} // ~namespace nn::nd::detail
