﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/fs/fs_Result.h>
#include <nn/fs/fs_SystemSaveData.h>
#include <nn/migration/detail/migration_AbstractStorage.h>

namespace nn { namespace migration { namespace detail {

class SaveDataStorage
    : public AbstractStorage
{
private:
    char m_VolumeName[32];
    const fs::SystemSaveDataId m_SaveId;
    const int64_t m_DataSize;
    const int64_t m_JournalSize;
    const uint32_t m_Flags;

    void Mount() const NN_NOEXCEPT;
    void Unmount() const NN_NOEXCEPT;

    template <size_t N>
    void GetFullPath(char (&fullPath)[N], const char* path) const NN_NOEXCEPT;

protected:
    virtual void CleanupImpl() const NN_NOEXCEPT final NN_OVERRIDE;

    virtual Result CreateImpl(const char* path, size_t sizeToReserve) const NN_NOEXCEPT final NN_OVERRIDE;
    virtual Result DeleteImpl(const char* path) const NN_NOEXCEPT final NN_OVERRIDE;
    virtual Result MoveImpl(const char* to, const char* from) const NN_NOEXCEPT final NN_OVERRIDE;
    virtual Result GetSizeImpl(size_t* pOutSize, const char* path) const NN_NOEXCEPT final NN_OVERRIDE;

    virtual Result CommitImpl() const NN_NOEXCEPT final NN_OVERRIDE;
    virtual Result WriteImpl(const char* path, const void* buffer, size_t bufferSize) const NN_NOEXCEPT final NN_OVERRIDE;
    virtual Result AppendImpl(const char* path, size_t offset, const void* buffer, size_t bufferSize) const NN_NOEXCEPT final NN_OVERRIDE;
    virtual Result ReadImpl(size_t* pOutActualSize, void* buffer, size_t bufferSize, const char* path, size_t offset) const NN_NOEXCEPT final NN_OVERRIDE;

public:
    SaveDataStorage(const char* volumeName, fs::SystemSaveDataId saveId, int64_t dataSize, int64_t journalSize, uint32_t flags) NN_NOEXCEPT;
    ~SaveDataStorage() NN_NOEXCEPT;
};

template <typename Config>
class SystemSaveDataStoragePolicy
{
public:
    class Storage final
        : public SaveDataStorage
    {
    public:
        Storage() NN_NOEXCEPT
            : SaveDataStorage(Config::VolumeName, Config::Id, Config::DataSize, Config::JournalSize, Config::Flags)
        {
        }
    };
};

}}} // ~namespace nn::migration::detail
