﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/sf/sf_Types.h>
#include <nn/sf/sf_NativeHandle.h>
#include <nn/ldn/ldn_PrivateTypes.h>
#include <nn/ldn/ldn_Types.h>
#include <nn/ldn/detail/ldn_LocalCommunicationServiceManager.h>

namespace nn { namespace ldn { namespace detail
{
    class LocalCommunicationServiceBase
    {
    public:

        explicit LocalCommunicationServiceBase(
            LocalCommunicationServiceManager* pManager) NN_NOEXCEPT;

        ~LocalCommunicationServiceBase() NN_NOEXCEPT;

        Result GetStateChangeEvent(
            nn::sf::Out<nn::sf::NativeHandle> pOutReadableHandle) const NN_NOEXCEPT;

        Result GetState(nn::sf::Out<Bit32> pOutState) const NN_NOEXCEPT;

        Result Scan(
            nn::sf::OutArray<NetworkInfo> pOutScanResultArray,
            nn::sf::Out<int16_t> pOutCount,
            const ScanFilter& filter,
            int16_t channel) NN_NOEXCEPT;

        Result ScanPrivate(
            nn::sf::OutArray<NetworkInfo> pOutScanResultArray,
            nn::sf::Out<int16_t> pOutCount,
            const ScanFilter& filter,
            int16_t channel) NN_NOEXCEPT;

        Result GetNetworkInfoAndHistory(
            nn::sf::Out<NetworkInfo> pOutNetwork,
            nn::sf::OutArray<NodeLatestUpdate> outUpdates) NN_NOEXCEPT;

        Result GetNetworkInfo(nn::sf::Out<NetworkInfo> pOutNetwork) const NN_NOEXCEPT;

        Result GetIpv4Address(
            nn::sf::Out<Ipv4Address> pOutAddress,
            nn::sf::Out<SubnetMask> pOutMask) const NN_NOEXCEPT;

        Result GetSecurityParameter(
            nn::sf::Out<SecurityParameter> pOutSecurityParameter) const NN_NOEXCEPT;

        Result GetNetworkConfig(
            nn::sf::Out<NetworkConfig> pOutNetworkConfig) const NN_NOEXCEPT;

        Result OpenAccessPoint() NN_NOEXCEPT;

        Result CloseAccessPoint() NN_NOEXCEPT;

        Result CreateNetwork(
            const NetworkConfig& network,
            const SecurityConfig& security,
            const UserConfig& user) NN_NOEXCEPT;

        Result CreateNetworkPrivate(
            const NetworkConfig& network,
            const SecurityConfig& securityConfig,
            const SecurityParameter& securityParam,
            const UserConfig& user,
            const nn::sf::InArray<AddressEntry>& entries) NN_NOEXCEPT;

        Result DestroyNetwork() NN_NOEXCEPT;

        Result Reject(Ipv4Address address) NN_NOEXCEPT;

        Result SetAdvertiseData(const nn::sf::InBuffer& data) NN_NOEXCEPT;

        Result SetStationAcceptPolicy(Bit8 policy) NN_NOEXCEPT;

        Result AddAcceptFilterEntry(MacAddress station) NN_NOEXCEPT;

        Result ClearAcceptFilter() NN_NOEXCEPT;

        Result OpenStation() NN_NOEXCEPT;

        Result CloseStation() NN_NOEXCEPT;

        Result Connect(
            const NetworkInfo& network,
            const SecurityConfig& security,
            const UserConfig& user,
            int version,
            Bit32 option) NN_NOEXCEPT;

        Result ConnectPrivate(
            const NetworkConfig& network,
            const SecurityConfig& securityConfig,
            const SecurityParameter& securityParam,
            const UserConfig& user,
            int version,
            Bit32 option) NN_NOEXCEPT;

        Result Disconnect() NN_NOEXCEPT;

        Result GetDisconnectReason(nn::sf::Out<int16_t> pOutReason) const NN_NOEXCEPT;

        Result SetWirelessControllerRestriction(Bit32 restriction) NN_NOEXCEPT;

    protected:

        nn::os::SystemEventType m_StateChangeEvent;
        LocalCommunicationServiceManager* m_pManager;
        int m_Context;
    };

}}} // namespace nn::ldn::detail
