﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

namespace nn { namespace ldn { namespace detail
{
    /**
     * @brief       認証に使用するプロトコルです。
     */
    enum AuthenticationProtocol
    {
        //! 認証方法が指定されていません。
        AuthenticationProtocol_None,

        //! チャレンジレスポンス方式で認証を行います。
        AuthenticationProtocol_ChallengeResponse
    };

    /**
     * @brief       認証結果を表す定数です。
     */
    enum AuthenticationResult
    {
        //! 認証を通過しました。
        AuthenticationResult_Success,

        //! 認証を禁止されているステーションです。
        AuthenticationResult_Forbidden,

        //! 不正な要求のため拒否しました。
        AuthenticationResult_BadRequest,

        //! タイムアウトで失敗しました。
        AuthenticationResult_Timeout,

        //! 互換性が無いプロトコルバージョンです。
        AuthenticationResult_IncompatibleVersion,

        //! 不明なステーションです。
        AuthenticationResult_UnknownStation,
    };

}}} // namespace nn::ldn::detail
