﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/lcs/detail/lcs_Version.h>
#include <nn/ldn/ldn_PrivateTypes.h>
#include <nn/ldn/ldn_Types.h>
#include <nn/nn_TimeSpan.h>

namespace nn { namespace lcs { namespace detail
{

    const size_t NetworkConfigSize = sizeof(nn::ldn::NetworkConfig);
    const size_t SecurityParameterSize = sizeof(nn::ldn::SecurityParameter);

    const nn::TimeSpan Timeout = nn::TimeSpan::FromSeconds(5);
    const nn::TimeSpan RetryInterval = nn::TimeSpan::FromMilliSeconds(200);


    typedef uint32_t Ipv4Address;

    struct MacAddress
    {
        Bit8 raw[6];
    };

    struct AddressEntry
    {
        Ipv4Address             ipv4Address;
        MacAddress              macAddress;
        uint8_t                 _reserve[6];
    };

    struct NetworkSetting
    {
        char networkConfig[NetworkConfigSize];
        char securityParam[SecurityParameterSize];
    };
    NN_STATIC_ASSERT(sizeof(NetworkSetting) == NetworkConfigSize + SecurityParameterSize);

    const size_t NetworkSettingSize = sizeof(NetworkSetting);

}}} // end of namespace nn::lcs
