﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/lcs/lcs_Types.h>
#include <nn/lcs/detail/lcs_Context.h>
#include <nn/lcs/detail/lcs_NodeManager.h>
#include <nn/lcs/detail/lcs_Resource.h>
#include <nn/lcs/detail/Advertise/lcs_AdvertiseManager.h>

namespace nn { namespace lcs { namespace detail
{
    const int WaitClientStateChangeTimeoutSeconds = 10;
    const int WaitClientDisconnectTimeoutSeconds = 10;
    const int WaitDisconnectIntervalMilliSeconds = 500;
    const int WaitSendCompletePacketIntervalMilliSeconds = 500;
    const nn::TimeSpan WaitSendingPacket = nn::TimeSpan::FromMilliSeconds(500);
    const nn::TimeSpan WaitRejoinTimeout = nn::TimeSpan::FromSeconds(20);
    const nn::TimeSpan WaitStartSharing = nn::TimeSpan::FromSeconds(1);

    class Host
    {

    public:
        Host() NN_NOEXCEPT;

        static void MonitorThreadEntry(void* arg) NN_NOEXCEPT
        {
            auto* p = static_cast<Host*>(arg);
            p->MonitorThread();
        }

        static void ComThreadEntry(void* arg) NN_NOEXCEPT
        {
            auto* p = static_cast<Host*>(arg);
            p->ComThread();
        }

        static void ShareThreadEntry(void* arg) NN_NOEXCEPT
        {
            auto* p = static_cast<Host*>(arg);
            p->ShareThread();
        }

        static void TimeoutThreadEntry(void* arg) NN_NOEXCEPT
        {
            auto* p = static_cast<Host*>(arg);
            p->TimeoutThread();
        }

        void ClearMemory() NN_NOEXCEPT;

        void ChangeState(State state) NN_NOEXCEPT;

        Result InitializeHost() NN_NOEXCEPT;

        void FinalizeHost() NN_NOEXCEPT;

        Result InitializeSocket(int retryCountMax) NN_NOEXCEPT;

        void FinalizeSocket()  NN_NOEXCEPT;

        Result Open(LcsResources* resource) NN_NOEXCEPT;

        Result Reopen(LcsResources* resource) NN_NOEXCEPT;

        void WaitMigrationClients() NN_NOEXCEPT;

        void Close() NN_NOEXCEPT;

        bool IsInitialized() NN_NOEXCEPT;

        void UpdateSessionInfo() NN_NOEXCEPT;

        void UpdateNodesInfo() NN_NOEXCEPT;

        void UpdateRequiredStorageSize() NN_NOEXCEPT;

        void GetSessionState(SessionState* pOutState) NN_NOEXCEPT;

        void GetProgress(Progress* pOutProgress) NN_NOEXCEPT;

        Result GetNodeProgress(NodeProgress* pOutNodeProgress, uint32_t index) NN_NOEXCEPT;

        Result GetEulaDataSize(size_t* pOutSize, const char* eulaDataPath) NN_NOEXCEPT;

        Result GetEulaData(
            size_t* pOutSize, void* buffer, size_t bufferSize, const char* eulaDataPath) NN_NOEXCEPT;

        Result GetResumeContext(SessionContext* pOutSessionContext) NN_NOEXCEPT;

        Result ResumeShare() NN_NOEXCEPT;

        void Start() NN_NOEXCEPT;

        Result InitializeNodeManager(const SessionSettings& settings) NN_NOEXCEPT;

        void SetAcceptance(bool policy) NN_NOEXCEPT;

        void DisconnectUnlistedClinet() NN_NOEXCEPT;

        void MonitorThread() NN_NOEXCEPT;

        void ComThread() NN_NOEXCEPT;

        void ShareThread() NN_NOEXCEPT;

        void TimeoutThread() NN_NOEXCEPT;

        void UpdateShareAppInfo(bool* pOutIsDown) NN_NOEXCEPT;

        void UpdateAdvertiseInfo() NN_NOEXCEPT;

        void UpdateAdvertiseSessionState() NN_NOEXCEPT;

        void UpdateAdvertiseProgress() NN_NOEXCEPT;

        void AcceptClient() NN_NOEXCEPT;

        void Reject(uint32_t index, ContentsShareFailureReason reason) NN_NOEXCEPT;

        void RecvPacket() NN_NOEXCEPT;

        void RecvApplicationControlDataSize(int socket) NN_NOEXCEPT;

        void RecvApplicationControlData(int socket) NN_NOEXCEPT;

        void RecvJoin(int socket, uint32_t index) NN_NOEXCEPT;

        void RecvLeave(int socket, uint32_t index) NN_NOEXCEPT;

        void RecvShareSystemClearRes(int socket, uint32_t index) NN_NOEXCEPT;

        void RecvShareSystemSendRes(int socket) NN_NOEXCEPT;

        void RecvShareSystemRecvRes(int socket, uint32_t index) NN_NOEXCEPT;

        void RecvShareContentClearRes(int socket, uint32_t index) NN_NOEXCEPT;

        void RecvShareContentSendRes(int socket, uint32_t index) NN_NOEXCEPT;

        void RecvShareContentRecvRes(int socket, uint32_t index) NN_NOEXCEPT;

        void RecvUpdate(int socket, uint32_t index) NN_NOEXCEPT;

        void RecvSuspend(int socket, uint32_t index) NN_NOEXCEPT;

        void RecvResume(int socket, uint32_t index) NN_NOEXCEPT;

        void RecvRejoin(int socket, uint32_t index) NN_NOEXCEPT;

        Result UpdateClient(int socket, uint32_t index) NN_NOEXCEPT;

        void SendRejectToAll(RejectReason reason) NN_NOEXCEPT;

        void SendSessionInfoToAll() NN_NOEXCEPT;

        void SendStartToAll() NN_NOEXCEPT;

        void SendEndContentsSareToAll() NN_NOEXCEPT;

        void MigrationFunction(uint32_t newHostIndex) NN_NOEXCEPT;

        bool ConfirmSystemUpdateSchedule() NN_NOEXCEPT;

        Result ConfirmContentShareSchedule() NN_NOEXCEPT;

        void UpdateHostDetailInfo(Bit64 id) NN_NOEXCEPT;

        bool ShareSystem(uint32_t receiverIndex, SystemUpdateReason reason) NN_NOEXCEPT;

        bool ShareContent(uint32_t receiverIndex, int appIndex) NN_NOEXCEPT;

        Result ReceiveApplication(const NodeDetailInfo& info, int appIndex) NN_NOEXCEPT;

        Result CommitApplication() NN_NOEXCEPT;

        bool GetCanShareSystemNodeIndex(uint32_t* pOutIndex) NN_NOEXCEPT;

        bool GetCanShareContentsNodeIndex(uint32_t* pOutIndex, int* pOutAppIndex) NN_NOEXCEPT;

        bool WaitClientResponse() NN_NOEXCEPT;

        Result WaitTask(nn::ns::AsyncResult* asyncResult, uint32_t index) NN_NOEXCEPT;

    private:
        LcsResources* m_pResource;

        nn::os::EventType m_StartTransferEvent;
        nn::os::EventType m_RecvResPacketEvent;
        nn::os::EventType m_ResumeEvent;
        nn::os::EventType m_ClientStateChangeEvent;
        nn::os::EventType m_CancelEvent;

        int64_t m_Time;

        bool m_IsOpened;
        bool m_IsAccepted;
        bool m_IsShareCompleted;
        bool m_IsNeedReboot;
        bool m_IsContentShareSucceeded;

        AdvertiseManager m_AdvertiseManager;
        NodeManager m_NodeManager;

        int m_Socket;
        Ipv4Address m_MyAddress;
        Bit8 m_Policy;

        SessionState m_SessionState;

        uint8_t m_Role;
        uint32_t m_NodeIndex;

        int64_t m_RequiredSize;

        bool m_IsSender;
        bool m_IsWaitReceiver;
        uint64_t m_TotalSendSize;
    };

}}} // end of namespace nn::lcs
