﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/lcs/lcs_Types.h>
#include <nn/lcs/detail/lcs_Context.h>
#include <nn/lcs/detail/lcs_Resource.h>
#include <nn/lcs/detail/lcs_Util.h>
#include <nn/lcs/detail/Advertise/lcs_Advertise.h>

namespace nn { namespace lcs { namespace detail
{

    enum LeaveType
    {
        LeaveType_Temporary,
        LeaveType_Permanent,
    };

    class Client
    {

    public:
        Client() NN_NOEXCEPT;

        static void MonitorThreadEntry(void* arg) NN_NOEXCEPT
        {
            Client* p = (Client*)arg;
            p->MonitorThread();
        }

        static void ComThreadEntry(void* arg) NN_NOEXCEPT
        {
            Client* p = (Client*)arg;
            p->ComThread();
        }

        static void ShareThreadEntry(void* arg) NN_NOEXCEPT
        {
            Client* p = (Client*)arg;
            p->ShareThread();
        }

        void ClearMemory() NN_NOEXCEPT;

        void ChangeState(State state, bool isDisconnect = false) NN_NOEXCEPT;

        Result InitializeClient() NN_NOEXCEPT;

        void FinalizeClient() NN_NOEXCEPT;

        Result InitializeSocket(Ipv4Address address, int retryCountMax) NN_NOEXCEPT;

        void FinalizeSocket()  NN_NOEXCEPT;

        Result Join(const SessionInfo& session, LcsResources* resource) NN_NOEXCEPT;

        Result Rejoin(LcsResources* resource) NN_NOEXCEPT;

        Result ConnectMigrationHost() NN_NOEXCEPT;

        Result Resume(const SessionContext& context, LcsResources* resource) NN_NOEXCEPT;

        void Leave(LeaveType type) NN_NOEXCEPT;

        bool IsInitialized() NN_NOEXCEPT;

        void UpdateSessionInfo() NN_NOEXCEPT;

        void UpdateRequiredStorageSize() NN_NOEXCEPT;

        void GetSessionState(SessionState* pOutState) NN_NOEXCEPT;

        void GetProgress(Progress* pOutProgress) NN_NOEXCEPT;

        Result GetNodeProgress(NodeProgress* pOutNodeProgress, uint32_t index) NN_NOEXCEPT;

        Result GetEulaDataSize(size_t* pOutSize, const char* eulaDataPath) NN_NOEXCEPT;

        Result GetEulaData(
            size_t* pOutSize, void* buffer, size_t bufferSize, const char* eulaDataPath) NN_NOEXCEPT;

        Result GetResumeContext(SessionContext* pOutSessionContext) NN_NOEXCEPT;

        Result ResumeShare() NN_NOEXCEPT;

        void MonitorThread() NN_NOEXCEPT;

        void ComThread() NN_NOEXCEPT;

        void ShareThread() NN_NOEXCEPT;

        bool RecvPacket() NN_NOEXCEPT;

        void RecvAccept() NN_NOEXCEPT;

        void RecvReject() NN_NOEXCEPT;

        void RecvSessionInfo() NN_NOEXCEPT;

        void RecvStartContentsSare() NN_NOEXCEPT;

        void RecvMigration() NN_NOEXCEPT;

        void RecvShareSystemClear() NN_NOEXCEPT;

        void RecvShareSystemSendReq() NN_NOEXCEPT;

        void RecvShareSystemRecvReq() NN_NOEXCEPT;

        void RecvShareContentClearReq() NN_NOEXCEPT;

        void RecvShareContentSendReq() NN_NOEXCEPT;

        void RecvShareContentRecvReq() NN_NOEXCEPT;

        void RecvEndContentShare() NN_NOEXCEPT;

        Result ReceiveSystemUpdate() NN_NOEXCEPT;

        Result ApplySystemUpdate() NN_NOEXCEPT;

        Result ReceiveApplication() NN_NOEXCEPT;

        Result CommitApplication() NN_NOEXCEPT;

        void MakeResumeContext() NN_NOEXCEPT;

        bool ExistsNode(uint32_t index) NN_NOEXCEPT;

        Result WaitTask(nn::ns::AsyncResult* asyncResult, uint32_t index) NN_NOEXCEPT;

        bool WaitSessionInfo() NN_NOEXCEPT;

    private:
        LcsResources* m_pResource;

        nn::os::EventType m_SessionInfoEvent;
        nn::os::EventType m_StartTransferEvent;
        nn::os::EventType m_CancelEvent;
        nn::os::EventType m_ResumeEvent;

        bool m_IsConnected;
        bool m_IsInitializedClient;
        bool m_IsShareCompleted;
        bool m_IsAcceptSystemUpdate;
        bool m_IsNeedReboot;

        int m_Socket;
        Ipv4Address m_MyAddress;
        Ipv4Address m_MasterAddress;

        AdvertiseData m_AdvertiseData;
        AdvertiseNodeProgress m_NodeProgress[NodeCountMax];

        uint8_t m_Role;
        uint32_t m_NodeIndex;

        int64_t m_RequiredSize;

        bool m_IsWaitReceiver;
        uint64_t m_TotalSendSize;
    };

}}} // end of namespace nn::lcs
