﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/ncm/ncm_ContentMeta.h>
#include <nn/ns/ns_ApplicationDeliveryInfo.h>

namespace nn { namespace lcs { namespace detail
{
    const size_t NsApplicationDeliveryInfoSize = sizeof(nn::ns::ApplicationDeliveryInfo);
    const size_t NcmContentMetaKeySize = sizeof(nn::ncm::ContentMetaKey);
    const int ApplicationDeliveryInfoCountMax = 16;
    const int ContentMetaKeyMax = 16;

    struct ApplicationDeliveryInfo
    {
        char appDeliveryInfo[NsApplicationDeliveryInfoSize];
    };
    NN_STATIC_ASSERT(sizeof(ApplicationDeliveryInfo) == 256);

    struct ContentMetaKey
    {
        char key[NcmContentMetaKeySize];
    };
    NN_STATIC_ASSERT(sizeof(ContentMetaKey) == 16);

    struct ContentMetaInfo
    {
        int metaKeyCount;
        ContentMetaKey metaKey[ContentMetaKeyMax];
    };

    struct DownloadTaskInfo
    {
        Bit64 id;
        ContentMetaInfo metaInfo;
    };

}}} // end of namespace nn::lcs
