﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief Pointing プロセッサに関する型の宣言。
 */

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_TimeSpan.h>
#include <nn/util/util_MathTypes.h>
#include <nn/irsensor/irsensor_ImageProcessorTypes.h>

namespace nn { namespace irsensor {

const int PointingProcessorMarkerObjectCount = 3; //!< Pointing で検出するマーカーオブジェクトの数です。

/**
 * @brief Pointing プロセッサの設定をおこなう Private 構造体です。
 */
struct PointingProcessorConfig
{
    Rect windowOfInterest;             //!< 撮影画像で処理対象となる矩形領域です（左上隅のピクセルを (0, 0) とする、幅 IrCameraImageWidth、高さ IrCameraImageHeight の領域内）。
};

/**
 * @brief Pointing プロセッサで検出したオブジェクトを表す構造体です。
 */
struct PointingObjectData
{
    bool isDataValid;            //!< オブジェクトが有効かどうかを表すフラグです。
    char reserved[7];
    float averageIntensity;      //!< オブジェクトの平均輝度値です（0 以上 IrCameraIntensityMax 以下）。
    ::nn::util::Float2 centroid; //!< オブジェクトの重心座標です。
    int32_t pixelCount;          //!< オブジェクトの面積です。
    Rect bound;                  //!< オブジェクトの外接矩形です。
};

/**
 * @brief Pointing プロセッサのマーカー情報も含めた処理結果を表す構造体です。
 */
struct PointingProcessorMarkerState
{
    int64_t samplingNumber;         //!< Pointing プロセッサから処理結果を得る度に増加する値です（0 以上）。
    ::nn::TimeSpanType timeStamp;   //!< 処理開始時点から処理結果を取得した時点までの時間情報です。過去データの時間との差分をとって扱います(0 以上)。
    PointingObjectData objects[PointingProcessorMarkerObjectCount];  //!< 検出した Pointing の3点マーカーのオブジェクト情報です。
};

}} // namespace nn::irsensor
