﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief Struct declaration for Bitimage Processor
 */

#pragma once

namespace nn { namespace irsensor {

#include <nn/util/util_MathTypes.h>

const uint32_t MaxParsedBitsWidth = 64;
const uint32_t MaxParsedBitsHeight = 64;

/**
 * @brief Structure for storing bitimage processor state
 */
struct BitImageProcessorState
{
    uint32_t id;
    bool     hasBitField;
    uint32_t bitFieldWidth;
    uint32_t bitFieldHeight;
    uint8_t  bitFieldData[MaxParsedBitsWidth * MaxParsedBitsHeight * 3];

    nn::util::Float2 phase;
    float roll;
    float pitch;
    float yaw;
    float height;
};

}} // namespace nn::irsensor

