﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/**
    @file
    @brief      irsensor モジュール用の、ログを出力する API の宣言です。
*/

#include <nn/nn_Common.h>
#include <nn/diag/detail/diag_DetailStructuredSdkLog.h>

#define NN_DETAIL_IRSENSOR_TRACE(...)                   NN_DETAIL_STRUCTURED_SDK_LOG(irsensor, Trace, 0, ##__VA_ARGS__)
#define NN_DETAIL_IRSENSOR_TRACE_V1(...)                NN_DETAIL_STRUCTURED_SDK_LOG(irsensor, Trace, 1, ##__VA_ARGS__)
#define NN_DETAIL_IRSENSOR_TRACE_V2(...)                NN_DETAIL_STRUCTURED_SDK_LOG(irsensor, Trace, 2, ##__VA_ARGS__)
#define NN_DETAIL_IRSENSOR_TRACE_V3(...)                NN_DETAIL_STRUCTURED_SDK_LOG(irsensor, Trace, 3, ##__VA_ARGS__)

#define NN_DETAIL_IRSENSOR_INFO(...)                    NN_DETAIL_STRUCTURED_SDK_LOG(irsensor, Info, 0, ##__VA_ARGS__)
#define NN_DETAIL_IRSENSOR_INFO_V1(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(irsensor, Info, 1, ##__VA_ARGS__)
#define NN_DETAIL_IRSENSOR_INFO_V2(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(irsensor, Info, 2, ##__VA_ARGS__)
#define NN_DETAIL_IRSENSOR_INFO_V3(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(irsensor, Info, 3, ##__VA_ARGS__)

#define NN_DETAIL_IRSENSOR_WARN(...)                    NN_DETAIL_STRUCTURED_SDK_LOG(irsensor, Warn, 0, ##__VA_ARGS__)
#define NN_DETAIL_IRSENSOR_WARN_V1(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(irsensor, Warn, 1, ##__VA_ARGS__)
#define NN_DETAIL_IRSENSOR_WARN_V2(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(irsensor, Warn, 2, ##__VA_ARGS__)
#define NN_DETAIL_IRSENSOR_WARN_V3(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(irsensor, Warn, 3, ##__VA_ARGS__)

#define NN_DETAIL_IRSENSOR_ERROR(...)                   NN_DETAIL_STRUCTURED_SDK_LOG(irsensor, Error, 0, ##__VA_ARGS__)
#define NN_DETAIL_IRSENSOR_ERROR_V1(...)                NN_DETAIL_STRUCTURED_SDK_LOG(irsensor, Error, 1, ##__VA_ARGS__)
#define NN_DETAIL_IRSENSOR_ERROR_V2(...)                NN_DETAIL_STRUCTURED_SDK_LOG(irsensor, Error, 2, ##__VA_ARGS__)
#define NN_DETAIL_IRSENSOR_ERROR_V3(...)                NN_DETAIL_STRUCTURED_SDK_LOG(irsensor, Error, 3, ##__VA_ARGS__)

#define NN_DETAIL_IRSENSOR_FATAL(...)                   NN_DETAIL_STRUCTURED_SDK_LOG(irsensor, Fatal, 0, ##__VA_ARGS__)
#define NN_DETAIL_IRSENSOR_FATAL_V1(...)                NN_DETAIL_STRUCTURED_SDK_LOG(irsensor, Fatal, 1, ##__VA_ARGS__)
#define NN_DETAIL_IRSENSOR_FATAL_V2(...)                NN_DETAIL_STRUCTURED_SDK_LOG(irsensor, Fatal, 2, ##__VA_ARGS__)
#define NN_DETAIL_IRSENSOR_FATAL_V3(...)                NN_DETAIL_STRUCTURED_SDK_LOG(irsensor, Fatal, 3, ##__VA_ARGS__)

#define NN_DETAIL_IRSENSOR_VTRACE(format, args)         NN_DETAIL_STRUCTURED_SDK_VLOG(irsensor, Trace, 0, format, args)
#define NN_DETAIL_IRSENSOR_VTRACE_V1(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(irsensor, Trace, 1, format, args)
#define NN_DETAIL_IRSENSOR_VTRACE_V2(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(irsensor, Trace, 2, format, args)
#define NN_DETAIL_IRSENSOR_VTRACE_V3(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(irsensor, Trace, 3, format, args)

#define NN_DETAIL_IRSENSOR_VINFO(format, args)          NN_DETAIL_STRUCTURED_SDK_VLOG(irsensor, Info, 0, format, args)
#define NN_DETAIL_IRSENSOR_VINFO_V1(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(irsensor, Info, 1, format, args)
#define NN_DETAIL_IRSENSOR_VINFO_V2(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(irsensor, Info, 2, format, args)
#define NN_DETAIL_IRSENSOR_VINFO_V3(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(irsensor, Info, 3, format, args)

#define NN_DETAIL_IRSENSOR_VWARN(format, args)          NN_DETAIL_STRUCTURED_SDK_VLOG(irsensor, Warn, 0, format, args)
#define NN_DETAIL_IRSENSOR_VWARN_V1(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(irsensor, Warn, 1, format, args)
#define NN_DETAIL_IRSENSOR_VWARN_V2(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(irsensor, Warn, 2, format, args)
#define NN_DETAIL_IRSENSOR_VWARN_V3(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(irsensor, Warn, 3, format, args)

#define NN_DETAIL_IRSENSOR_VERROR(format, args)         NN_DETAIL_STRUCTURED_SDK_VLOG(irsensor, Error, 0, format, args)
#define NN_DETAIL_IRSENSOR_VERROR_V1(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(irsensor, Error, 1, format, args)
#define NN_DETAIL_IRSENSOR_VERROR_V2(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(irsensor, Error, 2, format, args)
#define NN_DETAIL_IRSENSOR_VERROR_V3(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(irsensor, Error, 3, format, args)

#define NN_DETAIL_IRSENSOR_VFATAL(format, args)         NN_DETAIL_STRUCTURED_SDK_VLOG(irsensor, Fatal, 0, format, args)
#define NN_DETAIL_IRSENSOR_VFATAL_V1(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(irsensor, Fatal, 1, format, args)
#define NN_DETAIL_IRSENSOR_VFATAL_V2(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(irsensor, Fatal, 2, format, args)
#define NN_DETAIL_IRSENSOR_VFATAL_V3(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(irsensor, Fatal, 3, format, args)

#define NN_DETAIL_IRSENSOR_PUT_TRACE(text, length)      NN_DETAIL_STRUCTURED_SDK_PUT(irsensor, Trace, 0, text, length)
#define NN_DETAIL_IRSENSOR_PUT_TRACE_V1(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(irsensor, Trace, 1, text, length)
#define NN_DETAIL_IRSENSOR_PUT_TRACE_V2(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(irsensor, Trace, 2, text, length)
#define NN_DETAIL_IRSENSOR_PUT_TRACE_V3(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(irsensor, Trace, 3, text, length)

#define NN_DETAIL_IRSENSOR_PUT_INFO(text, length)       NN_DETAIL_STRUCTURED_SDK_PUT(irsensor, Info, 0, text, length)
#define NN_DETAIL_IRSENSOR_PUT_INFO_V1(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(irsensor, Info, 1, text, length)
#define NN_DETAIL_IRSENSOR_PUT_INFO_V2(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(irsensor, Info, 2, text, length)
#define NN_DETAIL_IRSENSOR_PUT_INFO_V3(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(irsensor, Info, 3, text, length)

#define NN_DETAIL_IRSENSOR_PUT_WARN(text, length)       NN_DETAIL_STRUCTURED_SDK_PUT(irsensor, Warn, 0, text, length)
#define NN_DETAIL_IRSENSOR_PUT_WARN_V1(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(irsensor, Warn, 1, text, length)
#define NN_DETAIL_IRSENSOR_PUT_WARN_V2(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(irsensor, Warn, 2, text, length)
#define NN_DETAIL_IRSENSOR_PUT_WARN_V3(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(irsensor, Warn, 3, text, length)

#define NN_DETAIL_IRSENSOR_PUT_ERROR(text, length)      NN_DETAIL_STRUCTURED_SDK_PUT(irsensor, Error, 0, text, length)
#define NN_DETAIL_IRSENSOR_PUT_ERROR_V1(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(irsensor, Error, 1, text, length)
#define NN_DETAIL_IRSENSOR_PUT_ERROR_V2(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(irsensor, Error, 2, text, length)
#define NN_DETAIL_IRSENSOR_PUT_ERROR_V3(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(irsensor, Error, 3, text, length)

#define NN_DETAIL_IRSENSOR_PUT_FATAL(text, length)      NN_DETAIL_STRUCTURED_SDK_PUT(irsensor, Fatal, 0, text, length)
#define NN_DETAIL_IRSENSOR_PUT_FATAL_V1(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(irsensor, Fatal, 1, text, length)
#define NN_DETAIL_IRSENSOR_PUT_FATAL_V2(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(irsensor, Fatal, 2, text, length)
#define NN_DETAIL_IRSENSOR_PUT_FATAL_V3(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(irsensor, Fatal, 3, text, length)
