﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief   振動に関する構造体のうち IPC を通るものの定義
 */

#pragma once

#include <nn/nn_Macro.h>
#include <nn/hid/hid_VibrationDeviceApi.h>

namespace nn { namespace hid {

/**
 * @brief   IPC 用の VibrationDeviceInfo 構造体です。
 */
struct VibrationDeviceInfoForIpc
{
    int32_t deviceType; //!< 振動子の物理的な種類
    int32_t position;   //!< 振動子の搭載位置

    //!< VibrationDeviceInfo を VibrationDeviceInfoForIpc に変換します。
    static inline VibrationDeviceInfoForIpc FromVibrationDeviceInfo(const VibrationDeviceInfo& vibrationDeviceInfo) NN_NOEXCEPT
    {
        VibrationDeviceInfoForIpc info;
        info.deviceType = static_cast<int32_t>(vibrationDeviceInfo.deviceType);
        info.position = static_cast<int32_t>(vibrationDeviceInfo.position);
        return info;
    }

    //!< VibrationDeviceInfoForIpc を VibrationDeviceInfo に変換します。
    inline VibrationDeviceInfo ToVibrationDeviceInfo() const NN_NOEXCEPT
    {
        VibrationDeviceInfo info;
        info.deviceType = static_cast<VibrationDeviceType>(deviceType);
        info.position = static_cast<VibrationDevicePosition>(position);
        return info;
    }
};

}} // namespace nn::hid
