﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief       JoyXpad に関する API の宣言
 */

#pragma once

#include <nn/nn_Macro.h>
#include <nn/hid/hid_JoyXpad.h>
#include <nn/hid/hid_SixAxisSensor.h>

namespace nn { namespace hid {

//! @name 6 軸センサー関連 API
//! @{

/**
 * @brief       SixAxisSensor のハンドルを取得します。
 *
 * @param[out]  pOutLeftHandle  左側の6軸センサーのハンドルの格納先
 * @param[out]  pOutRightHandle 右側の6軸センサーのハンドルの格納先
 * @param[in]   xpadId          Xpad ID
 *
 * @pre
 *              - 指定の Xpad ID と対応する Xpad について InitializeXpad() の呼び出しが完了している
 */
void GetSixAxisSensorHandles(SixAxisSensorHandle* pOutLeftHandle,
                             SixAxisSensorHandle* pOutRightHandle,
                             JoyXpadId xpadId) NN_NOEXCEPT;

//! @}

}} // namespace nn::hid
