﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
* @file  helloworld_Language.h
* @brief 列挙型 Language を定義します。
*/

#pragma once

namespace nn { namespace helloworld {

/**
* @brief   言語を表す列挙型です。
*
* @details 特定の言語に翻訳された "Hello, World!" 相当の文字列を取得する際に使用する、
*          言語を表す列挙型です。
*/
enum class Language
{
    English,  //!< 英語です。
    German,   //!< ドイツ語です。
    French,   //!< フランス語です。
    Japanese  //!< 日本語です。
};

}}
