﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/os.h>
#include <nn/applet/applet_FundamentalTypes.h>
#include <nn/sf/sf_Buffers.h>
#include <nn/sf/sf_Out.h>
#include <nn/sf/sf_NativeHandleFwd.h>
#include <nn/grc/grc_CommonTypes.h>
#include <nn/capsrv/capsrv_ApplicationData.h>

namespace nn{ namespace grcsrv{ namespace offscreen{

// @name MultiWait 管理
// @details
//   Initialize 不要
// @{
    static const int RequiredMultiWaitTagCount = 32;

    void SetupMultiWait(
        uintptr_t multiWaitTagBegin,
        uintptr_t multiWaitTagCount,
        void (*linkMultiWait)(nn::os::MultiWaitHolderType* pHolder, void* userPtr),
        void (*unlinkMultiWait)(nn::os::MultiWaitHolderType* pHolder, void* userPtr),
        void* userPtr
    ) NN_NOEXCEPT;

    void NotifyMultiWaitSignal(nn::os::MultiWaitHolderType* pHolder, bool isUnlinked) NN_NOEXCEPT;
// @}

// @name TransferMemory 管理
// @details
//   Initialize 不要
// @{
    nn::Result BindTransferMemory(void** pOutAddress, nn::sf::NativeHandle&& handle, size_t size) NN_NOEXCEPT;
    void UnbindTransferMemory() NN_NOEXCEPT;
// @}

    bool IsInitialized() NN_NOEXCEPT;

    nn::Result Initialize(void* pMemory, size_t size) NN_NOEXCEPT;
    void Finalize() NN_NOEXCEPT;


    nn::Result CreateLayer(uint64_t* pOutHandle, nn::applet::AppletResourceUserId rendererAruid) NN_NOEXCEPT;

    nn::Result DestroyLayer(uint64_t layerHandle) NN_NOEXCEPT;

    nn::Result GetLayerError(uint64_t layerHandle) NN_NOEXCEPT;

    nn::Result BindRendererLayer(
        int32_t* pOutBinderHandle,
        uint64_t layerHandle,
        nn::applet::AppletResourceUserId rendererAruid
    ) NN_NOEXCEPT;

    nn::Result UnbindRendererLayer(uint64_t layerHandle) NN_NOEXCEPT;

    nn::Result StartLayerRecording(uint64_t layerHandle, const nn::grc::OffscreenRecordingParameter& param) NN_NOEXCEPT;
    nn::Result AbortLayerRecording(uint64_t layerHandle) NN_NOEXCEPT;

    nn::Result RequestFinishLayerRecording(uint64_t layerHandle) NN_NOEXCEPT;
    nn::Result FinishLayerRecording(uint64_t layerHandle, const capsrv::ApplicationData& applicationData, const sf::InBuffer& thumbnailImage) NN_NOEXCEPT;

    nn::Result EncodeLayerAudioSample(size_t* pOutSize, uint64_t layerHandle, const void* buffer, size_t size) NN_NOEXCEPT;

    nn::Result GetLayerRecordingFinishReadyEvent(nn::sf::NativeHandle& outHandle, uint64_t layerHandle) NN_NOEXCEPT;
    nn::Result GetLayerAudioEncodeReadyEvent(nn::sf::NativeHandle& outHandle, uint64_t layerHandle) NN_NOEXCEPT;

    // android APIs
    void TransactParcel(
        std::int32_t handle,
        std::uint32_t code,
        const nn::sf::InBuffer& requestBuffer,
        const nn::sf::OutBuffer& replyBuffer,
        std::uint32_t flags
        ) NN_NOEXCEPT;

    void AdjustRefcount(
        std::int32_t handle,
        std::int32_t diff,
        std::int32_t isStrong
        ) NN_NOEXCEPT;

    void GetNativeHandle(
        std::int32_t handle,
        std::uint32_t code,
        nn::sf::Out<nn::sf::NativeHandle> result
        ) NN_NOEXCEPT;

    // testing APIs
    void SetCheckPointForTesting(std::uint64_t value) NN_NOEXCEPT;

}}}
