﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
* @file
* @brief ステートのデータに関する API の宣言（GX2 特殊版）
*/

#pragma once

#include <nn/nn_Common.h>

#include <nn/gfx/gfx_Common.h>
#include <nn/gfx/gfx_Variation-api.gx.h>
#include <nn/gfx/gfx_StateInfoData.h>

#include <nn/gfx/detail/gfx_Common-api.gx.h>
#include <nn/gfx/detail/gfx_Declare.h>

namespace nn {
namespace gfx {

/**
* @brief ラスタライザステートを表す構造体です（GX2 特殊版）
*/
template<>
struct RasterizerStateImplData< ApiVariationGx2 >
{
    enum State
    {
        State_NotInitialized,
        State_Initialized
    };
    Bit8 state; //!< オブジェクトの状態です。
    NN_PADDING3;

    uint32_t polygonControlRegister;
    uint32_t polygonOffsetRegister[ 5 ];
    uint32_t aaMaskRegister;
    detail::GxEnum aaModeRegister;
    detail::GxBool rasterizerEnable;
    detail::GxBool zClipEnable;
};

/**
* @brief カラーステートを表す構造体です（GX2 特殊版）
*/
template<>
struct BlendStateImplData< ApiVariationGx2 >
{
    struct BlendTargetState
    {
        nn::Bit32 blendControlRegister[ 2 ];
    };

    enum State
    {
        State_NotInitialized,
        State_Initialized
    };
    Bit8 state; //!< オブジェクトの状態です。
    NN_PADDING3;

    uint32_t colorControlRegister;
    uint32_t blendConstantColorRegister[ 4 ];
    uint32_t alphaToMaskRegister;
    uint32_t targetChannelMaskRegister;

    uint32_t blendTargetCount;

    uint32_t memorySize;
    detail::Ptr< BlendTargetState > pTargetArray;
};

/**
* @brief 深度ステンシルステートを表す構造体です（GX2 特殊版）
*/
template<>
struct DepthStencilStateImplData< ApiVariationGx2 >
{
    enum State
    {
        State_NotInitialized,
        State_Initialized
    };
    Bit8 state; //!< オブジェクトの状態です。
    NN_PADDING3;

    uint32_t depthStencilControlRegister;
    uint32_t stencilMaskRegister[ 2 ];
};


/**
* @brief 頂点ステートを表す構造体です（GX2 特殊版）
*/
template<>
struct VertexStateImplData< ApiVariationGx2 >
{
    struct Gx2FetchShader
    {
        detail::GxEnum    type;
        uint32_t _regs[ 1 ];
        uint32_t shaderSize;
        uint32_t shaderPtr; // Only runs on 32-bit systems
        uint32_t numAttribs;
        uint32_t _num_divisors;
        uint32_t _divisors[ 2 ];
    } fetchShader;

    enum State
    {
        State_NotInitialized,
        State_Initialized
    };
    Bit8 state; //!< オブジェクトの状態です。
    uint8_t attributeCount;
    NN_PADDING2;

    detail::Ptr< void > pMemory;
    detail::Ptr< void > fetchShaderData;
    uint32_t memorySize;
};

/**
* @brief テセレーションステートを表す構造体です（GX2 特殊版）
*/
template<>
struct TessellationStateImplData< ApiVariationGx2 >
{
    enum State
    {
        State_NotInitialized,
        State_Initialized
    };

    Bit8 state;
    NN_PADDING7;
};

/**
* @brief ビューポートシザーステートを表す構造体です（GX2 特殊版）
*/
template<>
struct ViewportScissorStateImplData< ApiVariationGx2 >
{
    enum Flag
    {
        Flag_ScissorEnable = ViewportScissorStateInfoData::Flag_ScissorEnable
    };
    enum State
    {
        State_NotInitialized,
        State_Initialized
    };
    Bit8 state; //!< オブジェクトの状態です。
    NN_PADDING3;

    uint32_t viewportRegister[ 12 ];
    uint32_t scissorRegister[ 2 ];
};

}
}
