﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
* @file
* @brief デバイスのデータに関する API の宣言（VK1 特殊版）
*/

#pragma once

#include <nn/nn_Common.h>

#if !defined( NN_BUILD_CONFIG_OS_SUPPORTS_HORIZON )
    #error
#endif

#include <nn/os/os_MutexTypes.h>

#include <nn/util/util_BitPack.h>
#include <nn/util/util_BitArray.h>

#include <nn/gfx/gfx_Common.h>
#include <nn/gfx/gfx_Variation-api.vk.h>
#include <nn/gfx/gfx_DeviceInfoData.h>

#include <nn/gfx/detail/gfx_Common-api.vk.h>
#include <nn/gfx/detail/gfx_Declare.h>
#include <nn/gfx/detail/gfx_Misc.h>

namespace nn {
namespace gfx {

/**
* @brief デバイスを表す構造体です（VK1 特殊版）
*/
template<>
struct DeviceImplData< ApiVariationVk1 >
{
    enum State
    {
        State_NotInitialized,
        State_Initialized
    };

    detail::VkHandle hInstance; //!< インスタンスハンドルです
    detail::VkHandle hPhysicalDevice; //!< 物理デバイスハンドルです
    detail::VkHandle hDevice; //!< 論理デバイスハンドルです
    detail::VkHandle hPipelineCache; //!< パイプラインキャッシュハンドルです
    detail::VkHandle hDebugCallback; //!< デバッグコールバックハンドルです

    char queueFamilyProperties[ 4 * 24 ]; //!< キューファミリープロパティーの保持領域です
    uint32_t queueFamilyPropertyCount; //!< キューファミリープロパティー数です
    uint32_t queueFamilyIndex; //!< キューファミリーインデックスです

    uint64_t minUniformBufferOffsetAlignment; //!< ユニフォームバッファーの最小の要求アラインメントです
    uint64_t minStorageBufferOffsetAlignment; //!< ストレージバッファーの最小の要求アラインメントです
    uint64_t minTexelBufferOffsetAlignment; //!< テクセルバッファーの最小の要求アラインメントです
    uint64_t nonCoherentAtomSize; //!< ホストコヒーレントなメモリーの単位サイズおよびアラインメントです
    uint32_t timestampComputeAndGraphics; //!< 全てのコンピュートおよびグラフィックスのキューでタイムスタンプをサポートする場合は非0の値が入ります
    uint32_t vendorId; //!< GPUベンダーのIDです
    float timestampPeriod; //!< タイムスタンプ1当りのnano秒時間です

    uint32_t memoryTypeCount; //!< メモリータイプの個数です
    uint32_t memoryPropertyFlags[ 32 ]; //!< 各メモリータイプの属性フラグです

    Bit8 state; //!< オブジェクトの状態です。
    Bit8 debugMode; //!< デバッグモードです
    char reserved[ 2 ]; //!< 予約領域です
    nn::util::BitPack32 availableExtensions; //!< 有効になっている拡張機能を示すフラグです
    nn::util::BitArray supportedFeaturesBitArray; //!< サポートされる機能です
    char supportedFeaturesBitArrayWorkMemory[8]; //!< supportedFeaturesBitArrayのワークメモリーです
    nn::os::MutexType mutex; //!< VkQueueのアクセスを排他するためのmutexです
    nn::os::MutexType resouceMutex; //!< リソースアクセスを排他するためのmutexです

    detail::Ptr< void > pBufferHeap; //!< バッファーヒープへのポインターです
    detail::Ptr< void > pAllocationCallback; //!< アロケーターコールバックです
    detail::Ptr< void > userPtr; //!< ユーザーポインターです

    detail::Ptr< void > pUserVkAllocator; //!< SetVkAllocatorで設定されたメモリーアロケーター構造体へのポインターです
    uint8_t allocationCallback[ sizeof( detail::Ptr< void > ) * 6 ]; //!< struct VkAllocationCallbacksの実体を格納します。

    detail::Ptr< void > pVkManagerList; //!< Vulkanオブジェクト管理モジュールのポインターです
};

}
}
