﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
* @file
* @brief デスクリプタープール初期化用の情報のデータに関する API の宣言
*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>

#include <nn/gfx/detail/gfx_Misc.h>

namespace nn {
namespace gfx {

/**
* @brief デスクリプタープールを初期化するための情報を表す構造体です。
*/
struct DescriptorPoolInfoData
{
    Bit8 descriptorPoolType; //!< nn::gfx::DescriptorPoolType によって表される、デスクリプタープールの種類です
    char reserved2[ 3 ]; //!< 予約領域です。
    uint32_t slotCount; //!< デスクリプターを格納するスロットの数です

    char reserved[ 24 ]; //!< 予約領域です
};

}
}
